var searchResultProvider = new SearchResultsProvider("MDG", "AutoCAD .NET Developer's Guide");
searchResultProvider.setTopicInfoList(["",{"title":"Introduction",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4875.htm",
"description":"This introduction describes the concepts of exposing AutoCAD objects through a managed .NET application programming interface (API). The AutoCAD .NET API allows you to automate tasks such as creating and modifying objects stored in the database of a drawing file or change the contents of a customization file. This guide covers using Microsoft Visual Studio 2008, and the programming languages Microsoft Visual Basic .NET (referred to in this guide as VB.NET) and Microsoft Visual C# with the AutoCAD .NET API.",
"ancestors":[]},
{"title":"Guide Organization",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-23b3.htm",
"description":"This guide provides information on how to use the AutoCAD .NET API with Microsoft Visual Studio and the programming languages VB.NET and C#. Information specific to developing applications using Microsoft Visual Studio can be found under the topics “Getting Started with Microsoft Visual Studio” and “Develop Applications with Microsoft Visual Studio.”",
"ancestors":[{"title": "Introduction","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4875.htm"}]},
{"title":"Overview of the AutoCAD .NET API",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-23fe.htm",
"description":"The AutoCAD .NET API enables you to manipulate AutoCAD and drawing files programmatically with the assemblies or libraries that are exposed. With these objects exposed, they can be accessed by many different programming languages and environments.",
"ancestors":[{"title": "Introduction","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4875.htm"}]},
{"title":"Components of the AutoCAD .NET API",
"href":"./filesMDG/WS73099cc142f48755-35a0330e12075abe904-7442.htm",
"description":"The AutoCAD .NET API is made up of different DLL files that contain a wide range of classes, structures, methods, and events that provide access to objects in a drawing file or the AutoCAD application. Each DLL file defines different namespaces which are used to organize the components of the libraries based on functionality.",
"ancestors":[{"title": "Introduction","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4875.htm"}]},
{"title":"Overview of Microsoft Visual Studio",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-23ee.htm",
"description":"Microsoft Visual Studio is an object-oriented programming environment that runs independently of AutoCAD. While Microsoft Visual Studio is external to AutoCAD and other applications, it is able to interact with applications that expose either a native .NET API or ActiveX/COM library.",
"ancestors":[{"title": "Introduction","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4875.htm"}]},
{"title":"Which Edition of Microsoft Visual Studio to Use",
"href":"./filesMDG/WS73099cc142f48755-35a0330e12075abe904-7446.htm",
"description":"Microsoft Visual Studio is available in multiple versions and editions. To use the .NET API for AutoCAD 2011, you need to use:",
"ancestors":[{"title": "Introduction","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4875.htm"},{"title": "Overview of Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-23ee.htm"}]},
{"title":"Use COM Interoperability with .NET",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-23ce.htm",
"description":"Microsoft Visual Studio can utilize both native .NET and COM interfaces in the same project. By utilizing COM interop, you can migrate existing code that might have been written in Visual Basic 6 or VBA without having to completely rewrite it. To access AutoCAD automation objects from a project created in Microsoft Visual Studio, create references to the following files:",
"ancestors":[{"title": "Introduction","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4875.htm"},{"title": "Overview of Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-23ee.htm"}]},
{"title":"Dependencies and Restrictions",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-23c3.htm",
"description":"Unlike ActiveX Automation, there are fewer issues with library conflicts when other applications are installed, reinstalled, or uninstalled. The reason for fewer compatibility issues is that the .NET Framework is a standardized platform. However, you can still run into dependency issues. To avoid dependency issues with the .NET Framework, be sure to use the same or an earlier version of the .NET Framework with your VB.NET or C# project that AutoCAD 2011 uses. For information on which version of the .NET Framework you should be referencing, see .",
"ancestors":[{"title": "Introduction","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4875.htm"},{"title": "Overview of Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-23ee.htm"}]},
{"title":"For More Information",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-23af.htm",
"description":"This guide assumes that you have working knowledge of either the VB.NET or C# programming languages, and does not attempt to duplicate or replace the abundance of documentation available on either of these programming languages. If you need more information on VB.NET or C#, and using Microsoft Visual Studio, see the Help system for Microsoft Visual Studio developed by Microsoft, available from the Help menu in Microsoft Visual Studio.",
"ancestors":[{"title": "Introduction","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4875.htm"}]},
{"title":"Sample Code",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-23ab.htm",
"description":"This guide and the AutoCAD 2011 ObjectARX SDK together contain a large number of sample projects, subroutines, and functions that demonstrate the use of the classes, structures, methods, properties, and events that make up the AutoCAD .NET API.",
"ancestors":[{"title": "Introduction","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4875.htm"}]},
{"title":"Transition from ActiveX Automation to .NET",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-239c.htm",
"description":"AutoCAD 2011 continues to support VBA, but the VBA components must be enabled by downloading and installing them from http://www.autodesk.com/vba-download.",
"ancestors":[{"title": "Introduction","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4875.htm"}]},
{"title":"Getting Started with Microsoft Visual Studio",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm",
"description":"This chapter introduces you to the AutoCAD .NET API and some of the basics of the Microsoft Visual Studio development environment. Along with an introduction to the development environment, you will also learn about the NETLOAD command in AutoCAD and some of the terminology used throughout this guide.",
"ancestors":[]},
{"title":"Understand Microsoft Visual Studio Projects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-47fd.htm",
"description":"Project files created with Microsoft Visual Studio are not specific to AutoCAD, but do contain specific project settings that you will need to be familiar with in order to create a DLL assembly file that can be loaded into AutoCAD. This guide discusses creating projects for Visual Basic (VB) .NET and Visual C# with and without the ObjectARX Wizard for AutoCAD 2011.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"}]},
{"title":"Define the Components in a Project",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4703.htm",
"description":"Each project can contain many different components. The different components of a project can contain class modules, forms, references, and resources.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"}]},
{"title":"View Project Information",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-470c.htm",
"description":"The Solution Explorer, which displays the current solution and a list of all loaded projects, also displays the code, class, and form module files contained in each loaded project, and the references to the external libraries used by each project.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"}]},
{"title":"Work with Microsoft Visual Studio Projects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-47ef.htm",
"description":"An open solution or project file can be viewed and accessed from the Solution Explorer. The Solution Explorer allows you to add new items and projects to the current solution and projects, unload a project from the current solution, change the properties of an opened solution or project, and add references to a project in the current solution, among many choices. All available tasks for working with the current solution or project can be accessed via the right-click menu of the Solution Explorer. For information on the Solution Explorer, see .",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"}]},
{"title":"Create a New Project",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-47a5.htm",
"description":"New projects are created based on a project template. When creating a new project that will be built into a DLL assembly that will be loaded into AutoCAD, use the Class Library template that comes with Microsoft Visual Studio or one of the AutoCAD Managed project application templates that get installed with the ObjectARX Wizard for AutoCAD 2011. Both types of templates are available for the VB.NET and C# programming languages.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Work with Microsoft Visual Studio Projects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-47ef.htm"}]},
{"title":"Open an Existing Project or Solution",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-47e4.htm",
"description":"When you open a project or solution in Microsoft Visual Studio, the code editor and Windows Form Designer windows are opened in the same state they were in when the project was last saved. Once a project or solution is opened, use the Solution Explorer to navigate between the files of the opened project or solution. For information on working with an open project or solution see, .",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Work with Microsoft Visual Studio Projects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-47ef.htm"}]},
{"title":"Save a Project or Solution",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4797.htm",
"description":"Microsoft Visual Studio is a contextual based development environment, meaning that the current item selected determines the available features in the development environment. Controlling which changed files you save or how you want to save them is determined by the Solution Explorer.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Work with Microsoft Visual Studio Projects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-47ef.htm"}]},
{"title":"Work with Multiple Projects in a Solution",
"href":"./filesMDG/WS73099cc142f48755-35a0330e12075abe904-6df6.htm",
"description":"A solution can contain multiple projects. Working with multiple projects is not much different than working with a single project. Use the Solution Explorer to navigate between the projects in the current solution.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Work with Microsoft Visual Studio Projects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-47ef.htm"}]},
{"title":"Edit an Existing Project or Solution",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4718.htm",
"description":"Once you have opened a project or solution into Microsoft Visual Studio, you can edit the projects, class modules, forms, and references using the common development environment. You can also debug and run projects from the common development environment.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"}]},
{"title":"Add New Items",
"href":"./filesMDG/WS73099cc142f4875539000486122982e6aa8-7397.htm",
"description":"New items such as class modules and Windows forms can be added to a project. You are responsible for updating the properties of an item (such as name) and for filling in the appropriate code. When naming new items, remember that other developers may want to use your items in future applications. Be sure to follow your company’s established naming conventions or the standards established by Microsoft.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Edit an Existing Project or Solution","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4718.htm"}]},
{"title":"Import Existing Items",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-46d9.htm",
"description":"Importing allows you to add an existing item to your project that might already exist in another project. You can import code or class modules and forms. Files with the VB extension can only be imported in a VB.NET project and CS files in a C# project. Class diagrams are stored as CD files and can be imported in either project type.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Edit an Existing Project or Solution","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4718.htm"}]},
{"title":"Edit Items",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-46c6.htm",
"description":"You edit code and class modules, and forms in the common development environment. Code and class modules are edited in a Code window, while forms are edited in the Windows Form Designer.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Edit an Existing Project or Solution","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4718.htm"}]},
{"title":"Use the Code Window",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-46b8.htm",
"description":"The Code window contains two drop-down lists, a split bar, and a margin indicator bar.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Edit an Existing Project or Solution","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4718.htm"},{"title": "Edit Items","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-46c6.htm"}]},
{"title":"Use the Windows Form Designer",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-46ab.htm",
"description":"The Windows Form Designer allows you to create custom dialog boxes for your project.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Edit an Existing Project or Solution","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4718.htm"},{"title": "Edit Items","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-46c6.htm"}]},
{"title":"Use the Properties Window",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7-5d50.htm",
"description":"The Properties window is used to change the properties of files in the current project or solution, as well as Windows forms and controls that are placed on a Windows form.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Edit an Existing Project or Solution","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4718.htm"},{"title": "Edit Items","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-46c6.htm"}]},
{"title":"Rename a Project",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-46a3.htm",
"description":"When a project is created, the name of the project file is stored with the project. If the name of a project file is changed outside of Visual Studio, the stored project name will not be changed to match. As a best practice, only rename your project or solution from Visual Studio to maintain consistency. For more information on creating a project, see .",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Edit an Existing Project or Solution","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4718.htm"}]},
{"title":"Add and Reference Other Projects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4680.htm",
"description":"Adding and referencing projects allows you to share code across multiple projects. You can create centralized libraries of commonly used methods, functions and classes, and then reference the library when needed. Projects can be referenced in the following ways:",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Edit an Existing Project or Solution","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4718.htm"}]},
{"title":"Set the Options for Microsoft Visual Studio",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4667.htm",
"description":"You can change the characteristics of the common development environment by using the Options dialog box.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Edit an Existing Project or Solution","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4718.htm"}]},
{"title":"Load an Assembly into AutoCAD",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-478b.htm",
"description":"Once a solution and project are created, a namespace and class are defined, and one or more command or AutoLISP function structures are implemented, you can use the NETLOAD command to load a .NET assembly into AutoCAD.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"}]},
{"title":"Access and Search Referenced Libraries (Object Browser)",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7-5d43.htm",
"description":"The Object Browser is used to view the objects of a library referenced by the projects in a current solution. From the Object Browser, you can navigate through a referenced library like you would a directory structure. You can also use the Search menu and locate an object based on an entered keyword.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"}]},
{"title":"Exercises: Create Your First Project",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7-5354.htm",
"description":"Now that you have learned the basics of using Microsoft Visual Studio, let\'s create a new project that defines a new command. Once the new command is defined, you will learn to load the .NET assembly into AutoCAD.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"}]},
{"title":"Exercise: Create a New Project",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4625.htm",
"description":"In this exercise, you will create a new project named “MyFirstProject” and reference the files of the AutoCAD .NET API.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Exercises: Create Your First Project","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7-5354.htm"}]},
{"title":"Exercise: Reference the AutoCAD .NET API Files",
"href":"./filesMDG/WS1a9193826455f5ff-3859b43c1209703a838-2ffb.htm",
"description":"In this exercise, you will reference the .NET assemblies acmgd.dll and acdbmgd.dll. After you reference the two files, you will adjust the properties of the referenced files so they are not copied to the build directory.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Exercises: Create Your First Project","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7-5354.htm"}]},
{"title":"Exercise: Create a New Command",
"href":"./filesMDG/WS1a9193826455f5ff-3859b43c1209703a838-2feb.htm",
"description":"Now that you have created a project and added the necessary library references, it is time to create a command. The command will create a new multiline text (MText) object in Model space. These and other concepts are discussed in-depth in later chapters.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Exercises: Create Your First Project","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7-5354.htm"}]},
{"title":"Exercise: Set the Target Framework for a Project",
"href":"./filesMDG/WS1a9193826455f5ff-e569a0121d1945c08-1a9e.htm",
"description":"In this exercise, you will specify the target framework that should be used when the project is built.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Exercises: Create Your First Project","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7-5354.htm"}]},
{"title":"Exercise: Build and Load a .NET Assembly in AutoCAD",
"href":"./filesMDG/WS1a9193826455f5ff-3859b43c1209703a838-2fe5.htm",
"description":"Now that you have a created a project and defined a command, you are almost ready to execute the command in AutoCAD. Before you can execute the command in AutoCAD, you need to first compile or build a .NET assembly file for your project.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"},{"title": "Exercises: Create Your First Project","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7-5354.htm"}]},
{"title":"Related AutoCAD Commands and Terminology",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-45e9.htm",
"description":"CommandsNETLOADLoads a .NET assembly into AutoCAD.The Choose .NET Assembly dialog box, a standard file selection dialog box, is displayed.When FILEDIA is set to 0 (zero), NETLOAD displays the followin",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"}]},
{"title":"More Information",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4612.htm",
"description":"More information on the Microsoft Visual Studio development environment, and the VB.NET or C# programming languages, is available from the Help files provided by Microsoft. To access the Help files, choose one of the options from the Help menu in Microsoft Visual Studio. You might also consider purchasing a book published by Microsoft Press or a third-party publisher.",
"ancestors":[{"title": "Getting Started with Microsoft Visual Studio","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2471.htm"}]},
{"title":"Basics of the AutoCAD .NET API",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm",
"description":"To use the AutoCAD .NET API effectively you should be familiar with the AutoCAD entities, objects, and features related to the tasks you want to automate. The greater your knowledge of an object\'s graphical and nongraphical properties, the easier it is for you to manipulate them through the AutoCAD .NET API. For information specific to the members (methods, functions or properties) of an object in the AutoCAD .NET API, see the AutoCAD .NET Reference Guide.",
"ancestors":[]},
{"title":"Understand the AutoCAD Object Hierarchy",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-233d.htm",
"description":"An object is the main building block of the AutoCAD .NET API. Each exposed object represents a precise part of AutoCAD. There are many different types of objects in the AutoCAD .NET API. Some of the objects represented in the AutoCAD .NET API are:",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"}]},
{"title":"The Application Object",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-232c.htm",
"description":"The Application object is the root object of the AutoCAD .NET API. From the Application object, you can access the main window as well as any open drawing. Once you have a drawing, you can then access the objects in the drawing. For information on working with open drawing files (documents) see, .",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Understand the AutoCAD Object Hierarchy","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-233d.htm"}]},
{"title":"The Document Object",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-231a.htm",
"description":"The Document object, which is actually an AutoCAD drawing, is part of the DocumentCollection object and provides access to the Database object which is associated with the Document object. The Database object contains all of the graphical and most of the nongraphical AutoCAD objects. For more information on the Database object, see .",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Understand the AutoCAD Object Hierarchy","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-233d.htm"}]},
{"title":"The Database Object",
"href":"./filesMDG/WS1a9193826455f5ff-3859b43c1209703a8386e7.htm",
"description":"The Database object contains all of the graphical and most of the nongraphical AutoCAD objects. Some of the objects contained in the database are entities, symbol tables, and named dictionaries. Entities in the database represent graphical objects within a drawing. Lines, circles, arcs, text, hatch, and polylines are examples of entities. A user can see an entity on the screen and can manipulate it.",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Understand the AutoCAD Object Hierarchy","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-233d.htm"}]},
{"title":"The Graphical and Nongraphical Objects",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2300.htm",
"description":"Graphical objects, also known as entities, are the visible objects (lines, circles, raster images, and so forth) that make up a drawing. Adding graphical objects to a drawing is done by referencing the correct block table record, and then using the AppendEntity method with the new object to append it to the drawing.",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Understand the AutoCAD Object Hierarchy","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-233d.htm"}]},
{"title":"The Collection Objects",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-230c.htm",
"description":"AutoCAD groups most graphical and nongraphical objects into collections or container objects. Although collections contain different types of data, they can be processed using similar techniques. Each collection has a method for adding an object to or obtaining an item from a collection. Most collections use the Add or SetAt methods to add an object to a collection.",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Understand the AutoCAD Object Hierarchy","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-233d.htm"}]},
{"title":"Non-Native Graphical and Nongraphical Objects",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-22f1.htm",
"description":"The AutoCAD .NET API is a cross implementation of ObjectARX and ActiveX Automation. While you can access ActiveX Automation from ObjectARX, .NET API makes working with the two rather seamless. As you work with objects using the native .NET API, you can access the equivalent COM object from a property. In some cases, the COM object is the only way to access an AutoCAD feature programmatically. Some examples of properties that expose COM objects through the .NET API are, Preferences, Menubar, MenuGroups, AcadObject and AcadApplication.",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Understand the AutoCAD Object Hierarchy","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-233d.htm"}]},
{"title":"Access the Object Hierarchy",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-22e0.htm",
"description":"While the Application is the root object in the AutoCAD .NET API, you commonly will be working with the database of the current drawing. The DocumentManager property of the Application object allows you to access the current document with the MdiActiveDocument property. From the Document object returned by the MdiActiveDocument property, you can access its database with the Database property.",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"}]},
{"title":"Reference Objects in the Object Hierarchy",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-22d4.htm",
"description":"When you work with objects in the .NET API, you can reference some objects directly or through a user-defined variable based on the object you are working with. To reference an objects directly, include the object in the calling hierarchy. For example, the following statement attaches a drawing file to the database of the current drawing. Notice that the hierarchy starts with the Application and then goes to the Database object. From the Database object, the AttachXref method is called:",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Access the Object Hierarchy","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-22e0.htm"}]},
{"title":"Access the Application Object",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-22c6.htm",
"description":"The Application object is at the root of the object hierarchy and it provides access to the main window of AutoCAD. For example, the following line of code updates the application:",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Access the Object Hierarchy","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-22e0.htm"}]},
{"title":"Collection Objects",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-22be.htm",
"description":"A collection is a type of object that contains many instances of similar objects. The following list contains some of the collection objects that are found in the AutoCAD .NET API:",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"}]},
{"title":"Access a Collection",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2275.htm",
"description":"Most collection and container objects are accessed through the Document or Database objects. The Document and Database objects contain a property to access an object or object id for most of the available Collection objects. For example, the following code defines a variable and retrieves the LayersTable object which represents the collection of Layers in the current drawing:",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Collection Objects","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-22be.htm"}]},
{"title":"Add a New Member to a Collection Object",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-226d.htm",
"description":"To add a new member to the collection, use the Add method. For example, the following code creates a new layer and adds it to the Layer table:",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Collection Objects","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-22be.htm"}]},
{"title":"Iterate through a Collection Object",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2268.htm",
"description":"To select a specific member of a Collection object, use the Item or GetAt method. The Item and GetAt methods require a key in the form of a string in which represents the name of the item. With most collections, the Item method is implied, meaning you do not actually need to use method.",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Collection Objects","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-22be.htm"}]},
{"title":"Erase a Member of a Collection Object",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-225b.htm",
"description":"Members from a collection object can be erased using the Erase method found on the member object. For example, the following code erases the layer MyLayer from the LayerTable object.",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Collection Objects","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-22be.htm"}]},
{"title":"Understand Properties and Methods",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2255.htm",
"description":"Each object has associated properties and methods. Properties describe aspects of the individual object, while methods are actions that can be performed on the individual object. Once an object is created, you can query and edit the object through its properties and methods.",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"}]},
{"title":"Out-of-Process versus In-Process",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2202.htm",
"description":"When you develop a new application, it can either run in or out-of-process. The AutoCAD .NET API is designed to run in-process only, which is different from the ActiveX Automation library which can be used in or -out-of-process.",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"}]},
{"title":"Define Commands and AutoLISP Functions",
"href":"./filesMDG/WS1a9193826455f5ff-e569a0121d1945c08-17d9.htm",
"description":"Commands and AutoLISP functions can be defined with the AutoCAD .NET API through the use of two attributes: CommandMethod and LispFunction. You place one of the two attributes before the method that should be called when the command or AutoLISP function is executed in AutoCAD.",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"}]},
{"title":"Command Definition",
"href":"./filesMDG/WS1a9193826455f5ff-e569a0121d1945c08-17d4.htm",
"description":"When defining a command, you use the CommandMethod attribute. The CommandMethod attribute expects a string value to use as the global name of the command that is being defined. Along with a global command name, the CommandMethod attribute can accept the following values:",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Define Commands and AutoLISP Functions","href":"./filesMDG/WS1a9193826455f5ff-e569a0121d1945c08-17d9.htm"}]},
{"title":"AutoLISP Function Definition",
"href":"./filesMDG/WS1a9193826455f5ff-e569a0121d1945c08-17c3.htm",
"description":"When defining an AutoLISP function, you use the LispFunction attribute. The LispFunction attribute expects a string value to use as the global name of the AutoLISP function that is being defined. Along with a global function name, the LispFunction structure can accept the following values:",
"ancestors":[{"title": "Basics of the AutoCAD .NET API","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4871.htm"},{"title": "Define Commands and AutoLISP Functions","href":"./filesMDG/WS1a9193826455f5ff-e569a0121d1945c08-17d9.htm"}]},
{"title":"Control the AutoCAD Environment",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm",
"description":"This chapter describes the fundamentals for developing an application that runs in-process with AutoCAD. It explains many of the concepts to control and work effectively with the AutoCAD environment.",
"ancestors":[]},
{"title":"Control the Application Window",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-439f.htm",
"description":"The ability to control the Application window allows developers the flexibility to create effective and intelligent applications. There will be times when it is appropriate for your application to minimize the AutoCAD window, perhaps while your code is performing work in another application such as Microsoft Excel. Additionally, you will often want to verify the state of the AutoCAD window before performing such tasks as prompting for input from the user.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"}]},
{"title":"Control the Drawing Windows",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm",
"description":"Like the AutoCAD Application window, you can minimize, maximize, reposition, resize, and check the state of any Document window. But you can also change the way the drawing is displayed within a window by using views, viewports, and zooming methods.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"}]},
{"title":"Position and Size the Document Window",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-437e.htm",
"description":"Use the Document object to modify the position and size of any document window. The Document window can be minimized or maximized by using the WindowState property, and you can find the current state of the Document window by using the WindowState property.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"}]},
{"title":"Zoom and Pan the Current View",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4369.htm",
"description":"A view is a specific magnification, position, and orientation of a drawing in the drawing window. You change a view of a drawing by changing the height, width and center point of the current view. Increasing or decreasing the width or height of a view affects the size in which a drawing is displayed. Panning a view is done by adjusting the center of the current view. For more information on zooming in AutoCAD, see “Change Views” in the AutoCAD User\'s Guide.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"}]},
{"title":"Manipulate the Current View",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4363.htm",
"description":"You access the current view of a viewport in Model or Paper space by using the GetCurrentView method of the Editor object. The GetCurrentView method returns a ViewTableRecord object. You use the ViewTableRecord object to manipulate the magnification, position, and orientation of the view in the active viewport. Once the ViewTableRecord object has been changed, you update the current view of the active viewport with the SetCurrentView method.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"},{"title": "Zoom and Pan the Current View","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4369.htm"}]},
{"title":"Define to Window",
"href":"./filesMDG/WS73099cc142f487551fea285e1221e4f9ff8-67e5.htm",
"description":"in AutoCAD, you use the Window option of the ZOOM command to define the area of the drawing that should be displayed in the drawing window. When you define the area to be displayed, the Width and Height properties of the current view are adjusted to match the area defined by the two points specified. Based on the specified points, the CenterPoint property of the view is also moved.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"},{"title": "Zoom and Pan the Current View","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4369.htm"}]},
{"title":"Scale a View",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4357.htm",
"description":"If you need to increase or decrease the magnification of the image in the drawing window, you change the Width and Height properties of the current view. When resizing a view, make sure to change the Width and Height properties by the same factor. The scale factor you calculate when resizing the current view will commonly be based on one of the following situations:",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"},{"title": "Zoom and Pan the Current View","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4369.htm"}]},
{"title":"Center Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4347.htm",
"description":"You can reposition the image in the drawing window by changing the center point of a view using the CenterPoint property. When the center point of a view is changed and the size of the view is not changed, the view is panned parallel to the screen. For information on resizing the image in the drawing window, see .",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"},{"title": "Zoom and Pan the Current View","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4369.htm"}]},
{"title":"Display Drawing Extents and Limits",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-433b.htm",
"description":"The extents or limits of a drawing are used to define the boundary in which the outermost objects appear in or the area defined by the limits of the current space.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"},{"title": "Zoom and Pan the Current View","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4369.htm"}]},
{"title":"Use Named Views",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4325.htm",
"description":"You can name and save a view you want to reuse. When you no longer need the view, you can remove it.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"}]},
{"title":"Use Tiled Viewports",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-430f.htm",
"description":"AutoCAD usually begins a new drawing using a single tiled viewport that fills the entire graphics area. You can split the drawing area of the Model tab to display several viewports simultaneously. For example, if you keep both the full and the detail views visible, you can see the effects of your detail changes on the entire drawing. In each tiled viewport, you can do the following:",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"}]},
{"title":"Identify and Manipulate the Active Viewport",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4302.htm",
"description":"The active viewport is represented in the Viewports table by a record named \"*Active\", which is not a unique name as all tiled viewports currently displayed on the Model tab are named \"*Active\". Each tiled viewport that is displayed is assigned a number. The number of the active viewport can be obtained by:",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"},{"title": "Use Tiled Viewports","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-430f.htm"}]},
{"title":"Make A Tiled Viewport Current",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-42f6.htm",
"description":"You enter points and select objects in the current viewport. To make a viewport current, use the CVPORT system variable and specify the viewport by its number that you want to set current.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"},{"title": "Use Tiled Viewports","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-430f.htm"}]},
{"title":"Update the Geometry in the Document Window",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-42db.htm",
"description":"Many of the actions you perform through the AutoCAD .NET API modify what is displayed in the drawing area. Not all of these actions immediately update the display of the drawing. This is designed so you can make several changes to the drawing without waiting for the display to be updated after every single action. Instead, you can bundle your actions together and make a single call to update the display when you have finished.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Control the Drawing Windows","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4386.htm"}]},
{"title":"Create, Open, Save, and Close Drawings",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-43ef.htm",
"description":"The DocumentCollection, Document, and Database objects provide access to the AutoCAD file methods.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"}]},
{"title":"Create and Open a Drawing",
"href":"./filesMDG/WS73099cc142f48755-385a98b0121d1bb015f-300c.htm",
"description":"To create a new drawing or open an existing drawing, use the methods of the DocumentCollection object. The Add method creates a new drawing file based on a drawing template and adds that drawing to the DocumentCollection. The Open method opens an existing drawing file.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Create, Open, Save, and Close Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-43ef.htm"}]},
{"title":"Save and Close a Drawing",
"href":"./filesMDG/WS73099cc142f48755-385a98b0121d1bb015f-3009.htm",
"description":"Use the SaveAs method of the Database object to save the contents of a Database object. When using the SaveAs method, you can specify if the database should be renamed and if a backup of the drawing on disk should be renamed to a backup file by providing True for the bBakAndRename parameter. You can determine if a database is using a default name of Drawing1, Drawing2, etc by checking the value of the DWGTITLED system variable. If DWGTITLED is 0, the drawing has not been renamed.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Create, Open, Save, and Close Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-43ef.htm"}]},
{"title":"Work with No Documents Open",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41ea.htm",
"description":"AutoCAD always starts up with a new or existing document open. It is possible, however, to close all documents during the current session.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Create, Open, Save, and Close Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-43ef.htm"}]},
{"title":"Lock and Unlock a Document",
"href":"./filesMDG/WS1a9193826455f5ff-e569a0121d1945c0831d.htm",
"description":"Requests to modify objects or access AutoCAD can occur in any context, and coming from any number of applications. To prevent conflicts with other requests, you are responsible for locking a document before you modify it. Failure to lock the document in certain contexts will cause a lock violation during the modification of the database. You want to lock the document when your application:",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"}]},
{"title":"Set AutoCAD Preferences",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-43d3.htm",
"description":"The .NET API does not contain any classes or methods to access the options in which are accessed through the AutoCAD Options dialog box. Access to these options is done through the ActiveX Automation library. You use the COM object returned from the Preferences property of the Application object.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"}]},
{"title":"Database Preferences",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-43a7.htm",
"description":"Along with application level preferences, there are drawing based preferences that are accessed with the Options dialog box that are stored in a drawing file. To access these stored settings, use the appropriate property on the Database object or use the GetSystemVariable and SetSystemVariable methods of the Application object.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Set AutoCAD Preferences","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-43d3.htm"}]},
{"title":"Set and Return System Variables",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-42c2.htm",
"description":"The Application object provides the SetSystemVariable and GetSystemVariable methods for setting and retrieving AutoCAD system variables. For example, to assign an integer to the MAXSORT system variable, use the following code:",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"}]},
{"title":"Draw with Precision",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-42bb.htm",
"description":"With AutoCAD you can create your drawings with precise geometry without performing tedious calculations. Often you can specify precise points without knowing the coordinates. Without leaving the drawing screen, you can perform calculations on your drawing and display various types of status information.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"}]},
{"title":"Adjust Snap and Grid Alignment",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-42b1.htm",
"description":"The grid is a visual guideline to measure distances, while Snap mode is used to restrict cursor movement. In addition to setting the spacing for the grid and Snap mode, you can adjust the rotation and type of snap used.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Draw with Precision","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-42bb.htm"}]},
{"title":"Use Ortho Mode",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-429f.htm",
"description":"As you draw lines or move objects, you can use Ortho mode to restrict the cursor to the horizontal or vertical axis. The orthogonal alignment is dependent on the current snap angle and UCS. Ortho mode works with activities that require you to specify a second point, such as when using the GetDistance or GetAngle methods. You can use Ortho not only to establish vertical or horizontal alignment but also to enforce parallelism or create regular offsets.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Draw with Precision","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-42bb.htm"}]},
{"title":"Calculate Points and Values",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4262.htm",
"description":"By using the methods provided by the Editor object and the Geometry and Runtime namespaces, you can quickly solve a mathematical problem or locate points in your drawing. Some of the available methods are:",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Draw with Precision","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-42bb.htm"}]},
{"title":"Calculate Areas",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4248.htm",
"description":"You can find the area of an arc, circle, ellipse, lightweight polyline, polyline, region, hatch, planar-closed spline or any other entity that is derived from the base type of Curve by using the Area property.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Draw with Precision","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-42bb.htm"}]},
{"title":"Calculate a Defined Area",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-423f.htm",
"description":"If the area you want to calculate is based on user specified points, you might consider creating an in memory object such as a lightweight polyline, and then query of the area of the object before discarding it. The following steps explain how you might accomplish this:",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Draw with Precision","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-42bb.htm"},{"title": "Calculate Areas","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4248.htm"}]},
{"title":"Prompt for User Input",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-422c.htm",
"description":"The Editor object, which is a child of the Document object, defines the user input methods. The user input methods display a prompt on the AutoCAD command line or in a dynamic input tooltip, and request input of various types. This type of user input is most useful for interactive input of screen coordinates, entity selection, and short-string or numeric values. If your application requires the input of numerous options or values, a Windows form may be more appropriate than individual prompts.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"}]},
{"title":"GetString Method",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4221.htm",
"description":"The GetString method prompts the user for the input of a string at the Command prompt. The PromptStringOptions object allows you to control the input entered and how the prompt message appears. The AllowSpaces property of the PromptStringOptions object controls if spaces are allowed or not at the prompt. If set to false, pressing the Spacebar terminates the input.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Prompt for User Input","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-422c.htm"}]},
{"title":"GetPoint Method",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4217.htm",
"description":"The GetPoint method prompts the user to specify a point at the Command prompt. The PromptPointOptions object allows you to control the input entered and how the prompt message appears. The UseBasePoint and BasePoint properties of the PromptPointOptions object controls if a rubber-band line is drawn from a base point. The Keywords property of the PromptPointOptions object allows you to define keywords that can be entered at the Command prompt in addition to specifying a point.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Prompt for User Input","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-422c.htm"}]},
{"title":"GetKeywords Method",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-420e.htm",
"description":"The GetKeywords method prompts the user for input of a keyword at the Command prompt. The PromptKeywordOptions object allows you to control the input entered and how the prompt message appears. The Keywords property of the PromptKeywordOptions object allows you to define keywords that can be entered at the Command prompt.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Prompt for User Input","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-422c.htm"}]},
{"title":"Control User Input",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41ff.htm",
"description":"When collecting input from the user, you want to make sure you limit the type of information they can enter so you can get the desired response. The various prompt option objects are used to not only define the prompt displayed at the Command prompt, but also restrict the input that the user can provide. With some of the input methods, not only can you get a return value based on the type of method used but also get a keyword.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"},{"title": "Prompt for User Input","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-422c.htm"}]},
{"title":"Access the AutoCAD Command Line",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41f1.htm",
"description":"You can send commands directly to the AutoCAD command line by using the SendStringToExecute method. The SendStringToExecute method sends a single string to the command line. The string must contain the arguments to the command listed in the order expected by the prompt sequence of the executed command.",
"ancestors":[{"title": "Control the AutoCAD Environment","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-246d.htm"}]},
{"title":"Create and Edit AutoCAD Entities",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm",
"description":"You can create a range of objects, from simple lines and circles to spline curves, ellipses, and associative hatch areas. In general, you add objects to a BlockTableRecord object using the AppendEntity function. Once an object is created, you can change its properties such as layer, color, and linetype.",
"ancestors":[]},
{"title":"Open and Close Objects",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f77e6.htm",
"description":"Whether you are working with objects such as lines, circles and polyline or a symbol table and its records, you need to open the object for read or write. When querying an object you want to open the object for read, but if you are going to make changes to the object you will want to open it for write.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"}]},
{"title":"Work with ObjectIds",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f77ea.htm",
"description":"Each object contained with in the Database object is assigned several unique ids. The unique ways you can access objects are:",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Open and Close Objects","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f77e6.htm"}]},
{"title":"Use Transactions with the Transaction Manager",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7802.htm",
"description":"Transactions are used to group multiple operations on multiple objects together as a single operation. Transactions are started and managed through the Transaction Manager. Once a transaction is started, you can then use the GetObject function to open an object.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Open and Close Objects","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f77e6.htm"}]},
{"title":"Start a New Transaction and Open an Object",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7a33.htm",
"description":"The Transaction Manager is accessed from the TransactionManager property of the current database. Once a reference to the Transaction Manager is made, you use the StartTransaction method to start a new transaction. StartTransaction creates an instance of a Transaction object and allows you to open objects with the GetObject method.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Open and Close Objects","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f77e6.htm"},{"title": "Use Transactions with the Transaction Manager","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7802.htm"}]},
{"title":"Commit and Rollback Changes",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7a46.htm",
"description":"When using transactions, you are able to decide when changes to objects are saved to the drawing database. You use the Commit method to save the changes made to the objects opened within a transaction. If your program encounters an error you can rollback any changes made within a transaction with the Abort method.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Open and Close Objects","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f77e6.htm"},{"title": "Use Transactions with the Transaction Manager","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7802.htm"}]},
{"title":"Nest Transactions",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7a3e.htm",
"description":"Transactions can be nested one inside another. You might have an outer transaction to undo all the changes made by your routine and inner transactions to undo just portions of the changes made. When you work with nested transactions, you start with a top transaction which is also the outer most transaction.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Open and Close Objects","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f77e6.htm"},{"title": "Use Transactions with the Transaction Manager","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7802.htm"}]},
{"title":"Open and Close Objects without the Transaction Manager",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7806.htm",
"description":"Transactions make it easier to open and work with multiple objects, but they are not the only way to open and edit objects. Other than using a transaction, you can open and close objects using the Open and Close methods. You still need to obtain an object id to use the Open method. Like the GetObject method used with transactions, you need to specify an open mode and the return value is an object. If you make changes to an object after you opened it with the Open method, you can use the Cancel method to rollback all the changes made since it was opened. Cancel must be called on each object in which you want to rollback.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Open and Close Objects","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f77e6.htm"}]},
{"title":"Upgrade and Downgrade Open Objects",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f780a.htm",
"description":"Once an object is opened using either the GetObject or Open methods, you can change the current open mode of an object with the UpgradeOpen and DowngradeOpen methods. The UpgradeOpen method changes an object open for read to write mode, while DowngradeOpen changes an object open for write to read mode. You do not need to pair a call to DowngradeOpen with each UpgradeOpen call, since closing of an object or disposing of a transaction will sufficiently cleanup the open state of an entity.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Open and Close Objects","href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f77e6.htm"}]},
{"title":"Create Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm",
"description":"AutoCAD often offers several different ways to create the same graphical object. While the .NET API does not offer the same combinations of creating objects, it does offer a basic object constructor for each object type but also offers overrides for many of the object constructors as well.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"}]},
{"title":"Determine the Parent Object",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41ba.htm",
"description":"Graphical objects are appended to a BlockTableRecord object, such as Model or Paper space. You reference the blocks that represent Model and Paper space through the BlockTable object. If you want to work in the current space instead of a specific space, you get the ObjectId for the current space from the current database with the CurrentSpaceId property.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"}]},
{"title":"Create Lines",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41a5.htm",
"description":"The line is the most basic object in AutoCAD. You can create a variety of lines—single lines, and multiple line segments with and without arcs. In general, you draw lines by specifying coordinate points. Lines when created, inherit the current settings from the drawing database, such as layer, linetype and color.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"}]},
{"title":"Create a Line Object",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f7205f.htm",
"description":"This example adds a line that starts at (5,5,0) and ends at (12,3,0) to Model space.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"},{"title": "Create Lines","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41a5.htm"}]},
{"title":"Create a Polyline object",
"href":"./filesMDG/WS73099cc142f48755f2fc9df120970276f72063.htm",
"description":"This example adds a lightweight polyline with two straight segments using the 2D coordinates (2,4), (4,2), and (6,4) to Model space.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"},{"title": "Create Lines","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41a5.htm"}]},
{"title":"Create Curved Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4180.htm",
"description":"You can create a variety of curved objects with AutoCAD, including splines, helixes, circles, arcs, and ellipses. All curves are created on the XY plane of the current UCS.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"}]},
{"title":"Create a Circle object",
"href":"./filesMDG/WS1a9193826455f5ff-3859b43c1209703a8386e0f.htm",
"description":"This example creates a circle in Model space with a center point of (2,3,0) and a radius of 4.25.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"},{"title": "Create Curved Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4180.htm"}]},
{"title":"Create an Arc object",
"href":"./filesMDG/WS1a9193826455f5ff-3859b43c1209703a8386e19.htm",
"description":"This example creates an arc in Model space with a center point of (6.25,9.125,0), a radius of 6, start angle of 1.117 (64 degrees), and an end angle of 3.5605 (204 degrees).",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"},{"title": "Create Curved Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4180.htm"}]},
{"title":"Create a Spline object",
"href":"./filesMDG/WS1a9193826455f5ff-3859b43c1209703a8386e23.htm",
"description":"This example creates a circle in Model space using three points (0, 0, 0), (5, 5, 0), and (10, 0, 0). The spline has start and end tangents of (0.5, 0.5, 0.0).",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"},{"title": "Create Curved Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4180.htm"}]},
{"title":"Create Point Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-415b.htm",
"description":"Point objects can be useful, for example, as node or reference points that you can snap to and offset objects from. You can set the style of the point and its size relative to the screen or in absolute units.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"}]},
{"title":"Create Solid-Filled Areas",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4144.htm",
"description":"You can create triangular and quadrilateral areas filled with a color. When creating filled areas, set the FILLMODE system variable to off to improve performance and back on once the fills have been created.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"}]},
{"title":"Work with Regions",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-412f.htm",
"description":"Regions are two-dimensional enclosed areas you create from closed shapes called loops. A loop is a closed boundary that is made up of straight and curved objects which do not intersect themselves. Loops can be combinations of lines, lightweight polylines, 2D and 3D polylines, circles, arcs, ellipses, elliptical arcs, splines, 3D faces, traces, and solids.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"}]},
{"title":"Create Regions",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4128.htm",
"description":"Regions are added to a BlockTableRecord object by creating an instance of a Region object and then appending it to a BlockTableRecord. Before you can add it to a BlockTableRecord object, a region needs to be calculated based on the objects that form the closed loop. The CreateFromCurves function creates a region out of every closed loop formed by the input array of objects. The CreateFromCurves method returns and requires a DBObjectCollection object.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"},{"title": "Work with Regions","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-412f.htm"}]},
{"title":"Create Composite Regions",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4116.htm",
"description":"You can create composite regions by subtracting, combining, or finding the intersection of regions or 3D solids. You can then extrude or revolve composite regions to create complex solids. To create a composite region, use the BooleanOperation method.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"},{"title": "Work with Regions","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-412f.htm"}]},
{"title":"Create Hatches",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-40f1.htm",
"description":"Closed boundaries can be filled with a pattern.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"}]},
{"title":"Create a Hatch Object",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-40e9.htm",
"description":"When creating a Hatch object, you specify the hatch pattern type, the hatch pattern name, and the associativity. Once a Hatch object has been created, you will not be able to change the hatch associativity.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"},{"title": "Create Hatches","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-40f1.htm"}]},
{"title":"Associate a Hatch",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-40e1.htm",
"description":"You can create associative or nonassociative hatches. Associative hatches are linked to their boundaries and updated when the boundaries are modified. Nonassociative hatches are independent of their boundaries.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"},{"title": "Create Hatches","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-40f1.htm"}]},
{"title":"Assign the Hatch Pattern Type and Name",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-40da.htm",
"description":"AutoCAD supplies a solid-fill and more than fifty industry-standard hatch patterns. Hatch patterns highlight a particular feature or area of a drawing. For example, patterns can help differentiate the components of a 3D object or represent the materials that make up an object.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"},{"title": "Create Hatches","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-40f1.htm"}]},
{"title":"Define the Hatch Boundaries",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-40c7.htm",
"description":"Once the Hatch object is created, the hatch boundaries can be added. Boundaries can be any combination of lines, arcs, circles, 2D polylines, ellipses, splines, and regions.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Create Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-41c0.htm"},{"title": "Create Hatches","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-40f1.htm"}]},
{"title":"Work with Selection Sets",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-409f.htm",
"description":"A selection set can consist of a single object, or it can be a more complex grouping: for example, the set of objects on a certain layer. A selection set is typically created by requesting a user to select an object in the drawing area before a command is started through pick first selection or at the Select objects: prompt when a command is active.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"}]},
{"title":"Obtain the PickFirst Selection Set",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4098.htm",
"description":"The PickFirst selection set is created when you select objects prior to starting a command. Several conditions must be present in order to obtain the objects of a PickFirst selection set, these conditions are:",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Work with Selection Sets","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-409f.htm"}]},
{"title":"Select Objects in the Drawing Area",
"href":"./filesMDG/WS1a9193826455f5ff-3859b43c1209703a838778b.htm",
"description":"You can select objects through by having the user interactively select objects, or you can simulate many of the various object selection options through the .NET API. If your routine performs multiple selection sets, you will need to either track each selection set returned or create an ObjectIdCollection object to keep track of all the selected objects. The following functions allow you to select objects from the drawing:",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Work with Selection Sets","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-409f.htm"}]},
{"title":"Add To or Merge Multiple Selection Sets",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-408e.htm",
"description":"You can merge multiple selection sets be creating an ObjectIdCollection object and then adding the object ids from multiple selection sets together. In addition to adding object ids to an ObjectIdCollection object, you can remove object ids. Once all object ids are added to an ObjectIdCollection object, you can iterate through the collection of object ids and manipulate each object as needed.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Work with Selection Sets","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-409f.htm"}]},
{"title":"Define Rules for Selection Filters",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-406f.htm",
"description":"You can limit which objects are selected and added to a selection set by using a selection filter. A selection filter list can be used to filter selected objects by properties or type. For example, you might want to select only blue objects or objects on a certain layer. You can also combine selection criteria. For example, you can create a selection filter that limits selection to blue circles on the layer named Pattern. Selection filters can be specified as a parameter for the different selection methods in .",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Work with Selection Sets","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-409f.htm"}]},
{"title":"Use Selection Filters to Define Selection Set Rules",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4067.htm",
"description":"Selection filters are composed of pairs of arguments in the form of TypedValues. The first argument of a TypedValue identifies the type of filter (for example, an object), and the second argument specifies the value you are filtering on (for example, circles). The filter type is a DXF group code that specifies which filter to use. A few of the most common filter types are listed here.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Work with Selection Sets","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-409f.htm"},{"title": "Define Rules for Selection Filters","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-406f.htm"}]},
{"title":"Specify Multiple Criteria in a Selection Filter",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4042.htm",
"description":"A selection filter can contain filtering criteria for more than just one property or object. You define the total number of conditions to filter on by declaring an array containing enough elements to represent each of the filter criterion.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Work with Selection Sets","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-409f.htm"},{"title": "Define Rules for Selection Filters","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-406f.htm"}]},
{"title":"Add Complexity to Your Filter List Conditions",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-403b.htm",
"description":"When you specify multiple selection criteria, AutoCAD assumes the selected object must meet each criterion. You can qualify your criteria in other ways. For numeric items, you can specify relational operations (for example, the radius of a circle must be greater than or equal to 5.0). And for all items, you can specify logical operations (for example, Text or MText).",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Work with Selection Sets","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-409f.htm"},{"title": "Define Rules for Selection Filters","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-406f.htm"}]},
{"title":"Use Wild-Card Patterns in Selection Set Filter Criteria",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4001.htm",
"description":"Symbol names and strings in selection filters can include wild-card patterns.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Work with Selection Sets","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-409f.htm"},{"title": "Define Rules for Selection Filters","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-406f.htm"}]},
{"title":"Filter for Extended Data",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fde.htm",
"description":"External applications can attach data such as text strings, numeric values, 3D points, distances, and layer names to AutoCAD objects. This data is referred to as extended data, or xdata. You can filter entities containing extended data for a specified application.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Work with Selection Sets","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-409f.htm"},{"title": "Define Rules for Selection Filters","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-406f.htm"}]},
{"title":"Remove Objects From a Selection Set",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fca.htm",
"description":"After you create a selection set, you can work with the object ids of the objects selected. Selection sets do not allow you to add or remove object ids from it, but you can use an ObjectIdCollection object to merge multiple selection sets into a single object to work with. You can add and remove object ids from an ObjectIdCollection object. Use the Remove or RemoveAt methods to remove an object id from an ObjectIdCollection object. For information on merging multiple selection sets and working with an ObjectIdCollection object, see .",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Work with Selection Sets","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-409f.htm"}]},
{"title":"Edit Named and 2D Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm",
"description":"Existing objects can be modified with the methods and properties associated with each object. If you modify a visible property of a graphic object, use the Regen method to redraw the object on screen. The Regen method is a member of the Editor object.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"}]},
{"title":"Work with Named Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fa9.htm",
"description":"In addition to the graphical objects used by AutoCAD, there are several types of nongraphical objects stored in a drawing database. These objects have descriptive designations associated with them. For example, blocks, layers, groups, and dimension styles all have a name assigned to them and in most cases can be renamed. The names of symbol table records are displayed in the user interface of AutoCAD, while the object id of an object is used to reference the object in most cases throughout the .NET API.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"}]},
{"title":"Purge Unreferenced Named Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fa1.htm",
"description":"Unreferenced named objects can be purged from a database at any time. You cannot purge named objects that are referenced by other objects. For example, a font file might be referenced by a text style or a layer might be referenced by the objects on that layer. Purging reduces the size of a drawing file when saved to disk.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Work with Named Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fa9.htm"}]},
{"title":"Rename Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f99.htm",
"description":"As your drawings become more complex, you can rename objects to keep the names meaningful or to avoid conflicts with names in other drawings you have inserted or attached. The Name property is used to get the current name or change the name of a named object.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Work with Named Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fa9.htm"}]},
{"title":"Erase Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3eef.htm",
"description":"You can delete non-graphical and graphical objects with the Erase method.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"}]},
{"title":"Copy Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f8a.htm",
"description":"You can create a copy of most nongraphical and graphical objects in a database. You create a copy of an object with the Clone function. Once an object is cloned, you can modify the returned object before it is added to the database. You can mimic many of the modifying commands in AutoCAD through the use of the Clone and TransformBy methods. For more information about the TransformBy method, see .",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"}]},
{"title":"Copy an Object",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f7e.htm",
"description":"To copy an object, use the Clone function provided for that object. This method creates a new object that is a duplicate of the original object. Once the duplicate object is created, you can then modify it prior to adding or appending it to the database. If you do not transform the object or change its position, the new object will be located in the same position as the original.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Copy Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f8a.htm"}]},
{"title":"Copy Objects between Databases",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f78.htm",
"description":"You can copy objects between two databases. The Clone function is used to copy objects within the same database, while the WblockCloneObjects method is used to copy objects from one database to another. The WblockCloneObjects method is a member of the Database object. The WblockCloneObjects method requires the following parameters:",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Copy Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f8a.htm"}]},
{"title":"Offset Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f64.htm",
"description":"Offsetting an object creates a new object at a specified offset distance from the original object. You can offset arcs, circles, ellipses, lines, lightweight polylines, polylines, splines, and xlines.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"}]},
{"title":"Transform Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ed5.htm",
"description":"You move, scale, rotate and mirror an object using a 4 by 4 transformation matrix represented by a Matrix3d object and the TransformBy method. You can also use the GetTransformedCopy method to create a copy of an entity and then apply the transformation to the copy. The Matrix3d object is part of the Geometry namespace.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"}]},
{"title":"Move Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f0b.htm",
"description":"You can move all drawing objects and attribute reference objects along a specified vector.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Transform Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ed5.htm"}]},
{"title":"Rotate Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3efe.htm",
"description":"You can rotate all drawing objects and attribute reference objects.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Transform Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ed5.htm"}]},
{"title":"Mirror Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f53.htm",
"description":"Mirroring flips an object along an axis or mirror line. You can mirror all drawing objects.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Transform Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ed5.htm"}]},
{"title":"Scale Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ee6.htm",
"description":"You scale an object by specifying a base point and scale factor based on the current drawing units. You can scale all drawing objects, as well as attribute reference objects.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Transform Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ed5.htm"}]},
{"title":"Array Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f3b.htm",
"description":"You can create a polar or rectangular array of an object. Arrays of objects are not created using a dedicated set of functions, but are created through a combination of copying objects, and then using a transformation matrix to rotate and move the copied object. The following outlines the basic logic for each type of array:",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"}]},
{"title":"Create Polar Arrays",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f34.htm",
"description":"This example creates a circle, and then performs a polar array of the circle. This creates four circles filling 180 degrees around a base point of (4, 4, 0).",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Array Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f3b.htm"}]},
{"title":"Create Rectangular Arrays",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f24.htm",
"description":"This example creates a circle and then performs a rectangular array of the circle, creating five rows and five columns of circles.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Array Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3f3b.htm"}]},
{"title":"Extend and Trim Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3e52.htm",
"description":"You can change the angle of arcs and you can change the length of lines, open polylines, elliptical arcs, and open splines. The results are similar to both extending and trimming objects.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"}]},
{"title":"Explode Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3e3e.htm",
"description":"Exploding an object converts the single object to its constituent parts. You use the Explode function to explode an object, and it requires a DBObjectCollection object in which is used to return the resulting objects. For example, exploding a polyline can result in the creation of an object collection that contains multiple lines and arcs.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"}]},
{"title":"Edit Polylines",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3e30.htm",
"description":"2D and 3D polylines, rectangles, polygons, donuts, and 3D polygon meshes are all polyline variants and are edited in the same way.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"}]},
{"title":"Edit Splines",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3e07.htm",
"description":"You can edit the properties of an open or closed spline, and even convert it to a polyline. Use the following properties to open or close a spline, change its control points, or reverse the direction of a spline:",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"}]},
{"title":"Edit Hatches",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d9d.htm",
"description":"You can edit both hatch boundaries and hatch patterns. If you edit the boundary of an associative hatch, the pattern is updated as long as the editing results in a valid boundary. Associative hatches are updated even if they\'re on layers that are turned off. You can modify hatch patterns or choose a new pattern for an existing hatch, but associativity can only be set when a hatch is created. You can check to see if a Hatch object is associative by using the Associative property.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"}]},
{"title":"Edit Hatch Boundaries",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d91.htm",
"description":"You can append, insert, or remove loops from the boundaries of a Hatch object. Associative hatches are updated to match any changes made to their boundaries. Non-associative hatches are not updated.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Edit Hatches","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d9d.htm"}]},
{"title":"Edit Hatch Patterns",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d77.htm",
"description":"You can change the angle or spacing of an existing hatch pattern or replace it with a solid-fill, gradient fill, or one of the predefined patterns that AutoCAD offers. The Pattern option in the Boundary Hatch dialog box displays a list of these patterns. To reduce file size, the hatch is defined in the drawing as a single graphic object.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Edit Named and 2D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3fb2.htm"},{"title": "Edit Hatches","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d9d.htm"}]},
{"title":"Use Layers, Colors, and Linetypes",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm",
"description":"Layers are like transparent overlays on which you organize and group different kinds of drawing information. The objects you create have properties including layers, colors, and linetypes. Color helps you distinguish similar elements in your drawings, and linetypes help you differentiate easily between different drafting elements, such as centerlines or hidden lines. Organizing layers and objects on layers makes it easier to manage the information in your drawings.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"}]},
{"title":"Work with Layers",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d47.htm",
"description":"You are always drawing on a layer. It may be the default layer or a layer you create and name yourself. Each layer has an associated color and linetype among other properties. For example, you can create a layer on which you draw only centerlines and assign the color blue and the linetype CENTER to that layer. Then, whenever you want to draw centerlines you can switch to that layer and start drawing.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"}]},
{"title":"Sort Layers and Linetypes",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d41.htm",
"description":"You can iterate through the Layers and Linetypes tables to find all the layers and linetypes in a drawing.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Layers","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d47.htm"}]},
{"title":"Create and Name Layers",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d3a.htm",
"description":"You can create new layers and assign color and linetype properties to those layers. Each individual layer is part of the Layers table. Use the Add function to create a new layer and add it to the Layers table.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Layers","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d47.htm"}]},
{"title":"Make a Layer Current",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d31.htm",
"description":"You are always drawing on the active layer. When you make a layer active, you create new objects on that layer. If you make a different layer active, any new objects you create is assigned that new active layer and uses its color and linetype. You cannot make a layer active if it is frozen.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Layers","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d47.htm"}]},
{"title":"Turn Layers On and Off",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d29.htm",
"description":"Layers in which are turned off are regenerated with the drawing but are not displayed or plotted. By turning layers off, you avoid regenerating the drawing every time you thaw a layer. When you turn a layer on that has been turned off, AutoCAD redraws the objects on that layer.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Layers","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d47.htm"}]},
{"title":"Freeze and Thaw Layers",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d1c.htm",
"description":"You can freeze layers to speed up display changes, improve object selection performance, and reduce regeneration time for complex drawings. AutoCAD does not display, plot, or regenerate objects on frozen layers. Freeze the layers that you will not be working with for long periods of time. When you “thaw” a frozen layer, AutoCAD regenerates and displays the objects on that layer.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Layers","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d47.htm"}]},
{"title":"Lock and Unlock Layers",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d12.htm",
"description":"You cannot edit objects on a locked layer; however, they are still visible if the layer is on and thawed. You can make a locked layer current and you can add objects to it. You can freeze and turn off locked layers and change their associated colors and linetypes.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Layers","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d47.htm"}]},
{"title":"Assign Color to a Layer",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d08.htm",
"description":"Each layer can have its own color assigned to it. Colors for a layer are identified by the Color object which is part of the Colors namespace. This object can hold an RGB value, ACI number (an integer from 1 to 255), or a color book color.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Layers","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d47.htm"}]},
{"title":"Assign a Linetype to a Layer",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cf7.htm",
"description":"When you are defining layers, linetypes provide another way to convey visual information. A linetype is a repeating pattern of dashes, dots, and blank spaces you can use to distinguish the purpose of one line from another.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Layers","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d47.htm"}]},
{"title":"Erase Layers",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cee.htm",
"description":"You can erase a layer at any time during a drawing session. You cannot erase the current layer, layer 0, an xref-dependent layer, or a layer that contains objects.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Layers","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d47.htm"}]},
{"title":"Work with Colors",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ce7.htm",
"description":"You can assign a color to an individual object in a drawing using its Color or ColorIndex property. The ColorIndex property accepts an AutoCAD Color Index (ACI) value as a numeric value of 0 - 256. The Color property is used to assign an ACI number, true color, or color book color to an object. To change the value of the Color property, you use the Color object which is under the Colors namespace.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"}]},
{"title":"Assign a color value to an object",
"href":"./filesMDG/WS73099cc142f48755-385a98b012180d20f19-3c0c.htm",
"description":"The following example creates 4 circles and assigns a different color to each circle using four different methods.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Colors","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ce7.htm"}]},
{"title":"Make a color current through the database",
"href":"./filesMDG/WS73099cc142f48755-385a98b012180d20f19-3c02.htm",
"description":"This example sets a color current through the Database object with the Cecolor property.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Colors","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ce7.htm"}]},
{"title":"Make a color current with the CECOLOR system variable",
"href":"./filesMDG/WS73099cc142f48755-385a98b012180d20f19-3bfa.htm",
"description":"This example sets the color Red current with the CECOLOR system variable.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Colors","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ce7.htm"}]},
{"title":"Work with Linetypes",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cc3.htm",
"description":"A linetype is a repeating pattern of dashes, dots, and blank spaces. A complex linetype is a repeating pattern of symbols. To use a linetype you must first load it into your drawing. A linetype definition must exist in a LIN library file before a linetype can be loaded into a drawing. To load a linetype into your drawing, use the member method LoadLineTypeFile of a Database object.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"}]},
{"title":"Make a Linetype Active",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cb2.htm",
"description":"To use a linetype, you must make it active. All newly created objects are drawn using the active linetype. There are two different methods for applying a linetype to an object: direct or inherited. You can directly assign a linetype to an object which overrides the linetype assigned to the layer the object is on. Otherwise, an object inherits the linetype of the layer it is on by having its Linetype or LinetypeId property set to represent the ByLayer linetype.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cc3.htm"}]},
{"title":"Assign a linetype to an object",
"href":"./filesMDG/WS73099cc142f48755-385a98b012180d20f19-3bda.htm",
"description":"The following example creates a circle and assigns the “Center” linetype to it.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cc3.htm"},{"title": "Make a Linetype Active","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cb2.htm"}]},
{"title":"Make a linetype current through the database",
"href":"./filesMDG/WS73099cc142f48755-385a98b012180d20f19-3bd0.htm",
"description":"This example sets a linetype current through the Database object with the Celtype property.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cc3.htm"},{"title": "Make a Linetype Active","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cb2.htm"}]},
{"title":"Make a linetype current with the CELTYPE system variable",
"href":"./filesMDG/WS73099cc142f48755-385a98b012180d20f19-3bcd.htm",
"description":"This example sets a linetype current with the CELTYPE system variable.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cc3.htm"},{"title": "Make a Linetype Active","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cb2.htm"}]},
{"title":"Rename Linetypes",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ca7.htm",
"description":"To rename a linetype, use the Name property. When you rename a linetype, you are renaming only the linetype definition in your drawing. The name in the LIN library file is not updated to reflect the new name.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cc3.htm"}]},
{"title":"Delete Linetypes",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ca1.htm",
"description":"To delete a linetype, use the Erase method. You can delete a linetype at any time during a drawing session; however, linetypes that cannot be deleted include BYLAYER, BYBLOCK, CONTINUOUS, the current linetype, a linetype in use, and xref-dependent linetypes. Also, linetypes referenced by block definitions cannot be deleted, even if they are not used by any objects.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cc3.htm"}]},
{"title":"Change Linetype Descriptions",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c9a.htm",
"description":"Linetypes can have a description associated with them. The description provides an ASCII representation of the linetype. You can assign or change a linetype description by using the AsciiDescription property.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cc3.htm"}]},
{"title":"Specify Linetype Scale",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c91.htm",
"description":"You can specify the linetype scale for objects you create. The smaller the scale, the more repetitions of the pattern are generated per drawing unit. By default, AutoCAD uses a global linetype scale of 1.0, which is equal to one drawing unit. You can change the linetype scale for all drawing objects and attribute references.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Use Layers, Colors, and Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3d4e.htm"},{"title": "Work with Linetypes","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3cc3.htm"}]},
{"title":"Save and Restore Layer States",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c49.htm",
"description":"You can save layer states in a drawing and restore them later. This makes it easy to return to specified settings for all layers during different stages when completing a drawing or when plotting a drawing.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"}]},
{"title":"Understand How AutoCAD Saves Layer States",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c3f.htm",
"description":"AutoCAD saves layer setting information in an extension dictionary of the Layers table object. When you first save a layer state, AutoCAD does the following:",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Save and Restore Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c49.htm"}]},
{"title":"Use the LayerStateManager to Manage Layer States",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c2b.htm",
"description":"The LayerStateManager object provides a set of functions for creating and manipulating saved layer states. Use the following LayerStateManager functions for working with layer states:",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Save and Restore Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c49.htm"}]},
{"title":"Save Layer States",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c0a.htm",
"description":"Use the SaveLayerState method to save a set of layer settings in a drawing. The SaveLayerState method requires three parameters. The first parameter is a string naming the layer state you are saving. The second parameter identifies the layer properties you want to save. Use the constants of the LayerStateMasks enum to identify the layer settings you want to save. The following table lists the constants that are part of the LayerStateMasks enum.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Save and Restore Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c49.htm"},{"title": "Use the LayerStateManager to Manage Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c2b.htm"}]},
{"title":"Rename Layer States",
"href":"./filesMDG/WS1a9193826455f5ff-e569a012180ce5891-2c48.htm",
"description":"The RenameLayerState method renames a saved layer state from one name to another in a drawing. The following code renames the ColorLinetype layer settings to OldColorLinetype.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Save and Restore Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c49.htm"},{"title": "Use the LayerStateManager to Manage Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c2b.htm"}]},
{"title":"Delete Layer States",
"href":"./filesMDG/WS1a9193826455f5ff-e569a012180ce5891-2c44.htm",
"description":"The DeleteLayerState method removes a saved layer state from a drawing. The following code deletes the layer state saved under the name ColorLinetype.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Save and Restore Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c49.htm"},{"title": "Use the LayerStateManager to Manage Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c2b.htm"}]},
{"title":"Restore Layer States",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bda.htm",
"description":"The RestoreLayerState method resets the layer settings in a layer state and requires four values. The first value is the name of the layer state to restore, and the second value is the object id of the viewport whose layer settings you want to restore. The third value is an integer that defines how layers not in the layer state are handled. The fourth value determines which layer settings are restored.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Save and Restore Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c49.htm"},{"title": "Use the LayerStateManager to Manage Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c2b.htm"}]},
{"title":"Export and Import Saved Layer States",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bd1.htm",
"description":"You can export and import saved layer states to use the same layer settings in other drawings. Use the ExportLayerState method to export a saved layer state to an LAS file; use the ImportLayerState method to import a LAS file into a drawing.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Save and Restore Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c49.htm"},{"title": "Use the LayerStateManager to Manage Layer States","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3c2b.htm"}]},
{"title":"Add Text to Drawings",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm",
"description":"Text conveys important information in your drawing. Use text objects for title blocks, to label parts of the drawing, to give specifications, or to make annotations.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"}]},
{"title":"Work with Text Styles",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bb2.htm",
"description":"All text in an AutoCAD drawing has a style associated with it. When you enter text, AutoCAD uses the current text style, which sets the font, size, angle, orientation, and other text characteristics. You can use or modify the default style or create and load a new style. Once you\'ve created a style, you can modify its attributes or delete it when you no longer need it.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"}]},
{"title":"Create and Modify Text Styles",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3baa.htm",
"description":"New text inherits height, width factor, obliquing angle, and text generation properties from the current text style. To create a text style, create a new instance of a TextStyleTableRecord object. Assign the new text style a name using the Name property. Then open the TextStyleTable object for write and use the Add method to create the new text style.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Work with Text Styles","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bb2.htm"}]},
{"title":"Assign Fonts",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b81.htm",
"description":"Fonts define the shapes of the text characters that make up each character set. A single font can be used by more than one style. Use the FileName property to set the font file for the text style. You can assign TrueType or AutoCAD-compiled SHX fonts to a text style.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Work with Text Styles","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bb2.htm"}]},
{"title":"Use TrueType Fonts",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b76.htm",
"description":"TrueType fonts always appear filled in your drawing; however, when you plot, the TEXTFILL system variable controls whether the fonts are filled. By default TEXTFILL is set to 1 to plot the filled-in fonts. When you export a drawing to PostScript® format and print it on a PostScript device, the font is plotted as designed.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Work with Text Styles","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bb2.htm"}]},
{"title":"Use Unicode and Big Fonts",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b6b.htm",
"description":"AutoCAD supports the Unicode character-encoding standard. A Unicode font can contain 65,535 characters, with shapes for many languages. All of the AutoCAD SHX shape fonts that are shipped with the product support Unicode fonts.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Work with Text Styles","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bb2.htm"}]},
{"title":"Set Text Height",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b59.htm",
"description":"Text height determines the size in drawing units of the letters in the font you are using. The value usually represents the size of the uppercase letters, with the exception of TrueType fonts.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Work with Text Styles","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bb2.htm"}]},
{"title":"Set Obliquing Angle",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b49.htm",
"description":"The obliquing angle determines the forward or backward slant of the text. The angle represents the offset from its vertical axis (90 degrees). To set the obliquing angle, use the ObliquingAngle property to change a text style or the Oblique property of a text object. The obliquing angle must be provided in radians. A positive angle denotes a lean to the right, a negative value will have 2*PI added to it to convert it to its positive equivalent.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Work with Text Styles","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bb2.htm"}]},
{"title":"Set Text Generation Flag",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b3c.htm",
"description":"The text generation flag specifies if text is displayed backwards or upside-down. Use the FlagBits property to define if a text style controls the display of text to be displayed backwards or upside-down, or use the IsMirroredInX and IsMirroredInY properties of a text object to control individually control a text object.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Work with Text Styles","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bb2.htm"}]},
{"title":"Use Single-Line Text (Text)",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b2f.htm",
"description":"The text you add to your drawings conveys a variety of information. It may be a complex specification, title block information, a label, or even part of the drawing. For shorter entries that do not require multiple fonts or lines, create an instance of a DBText object which represents a single-line of text and is convenient for labels.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"}]},
{"title":"Create Single-Line Text",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b2a.htm",
"description":"Each individual line of text is a distinct object when using single-line text. To create a single-line text object, you create an instance of a DBText object and then add it to either the block table record that represents Model or Paper space. When you create a new instance of a DBText object, you do not pass the constructor any parameters.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Use Single-Line Text (Text)","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b2f.htm"}]},
{"title":"Format Single-Line Text",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b22.htm",
"description":"A single-text object is created using the active text style. You can change the formatting of a single-line text object by changing the text style associated with it, or by editing the properties of the single-line text object directly. You cannot apply formats to individual words and characters with single-line text objects.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Use Single-Line Text (Text)","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b2f.htm"}]},
{"title":"Align Single-Line Text",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3af5.htm",
"description":"You can justify single-line text horizontally and vertically. Left alignment is the default. To set the horizontal and vertical alignment options, use the HorizontalMode and VerticalMode properties.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Use Single-Line Text (Text)","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b2f.htm"}]},
{"title":"Change Single-Line Text",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ae8.htm",
"description":"Like any other object, text objects can be moved, rotated, erased, and copied. You also can mirror text. If you do not want the text to be reversed when you mirror it, you can set the MIRRTEXT system variable to 0. You move, rotate and copy objects using the TransformBy and Clone methods. For more information on the TransformBy and Clone methods, see .",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Use Single-Line Text (Text)","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3b2f.htm"}]},
{"title":"Use Multiline Text (MText)",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ac3.htm",
"description":"For long, complex entries, create multiline text (MText). Multiline text fits a specified width but can extend vertically to an indefinite length. You can format individual words or characters within the MText.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"}]},
{"title":"Create Multiline Text",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3abc.htm",
"description":"You can create a multiline text object by first creating an instance of a MText object and then adding it to a block table record that represents Model or Paper space. The MText object constructor does not take any parameters. After an instance of an MText object is created, you can then assign it a text string, insertion point, and width among other values using its properties. Other properties that you can change affect the object’s text height, justification, rotation angle, and text style, or apply character formatting to selected characters",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Use Multiline Text (MText)","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ac3.htm"}]},
{"title":"Format Multiline Text",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3aa9.htm",
"description":"Newly created multiline text automatically assumes the characteristics of the current text style. The default text style is STANDARD. You can override the default text style by applying formatting to individual characters and applying properties to the multiline text object. You also can indicate formatting or special characters using the methods described in this section.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"},{"title": "Use Multiline Text (MText)","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3ac3.htm"}]},
{"title":"Use Unicode Characters, Control Codes, and Special Characters",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3a8e.htm",
"description":"You can use Unicode characters, control codes, and special characters in a text string to represent symbols. (All nontext characters must be entered as their ASCII equivalent.)",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"}]},
{"title":"Substitute Fonts",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3a66.htm",
"description":"You can designate fonts to be substituted for other fonts or as defaults when AutoCAD cannot find a font specified in a drawing.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"}]},
{"title":"Check Spelling",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3a52.htm",
"description":"During a spelling check, AutoCAD matches the words in the drawing to the words in the current main dictionary. Any words you add are stored in the custom dictionary that is current at the time of the spelling check. For example, you can add proper names so that AutoCAD no longer identifies them as misspelled words.",
"ancestors":[{"title": "Create and Edit AutoCAD Entities","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-486d.htm"},{"title": "Add Text to Drawings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3bbc.htm"}]},
{"title":"Dimensions and Tolerances",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm",
"description":"Dimensions add measurements to a drawing. Tolerances specify by how much a dimension can vary. With .NET API, dimensions can be managed with dimension styles and overrides.",
"ancestors":[]},
{"title":"Dimensioning Concepts",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-21ab.htm",
"description":"Dimensions show the geometric measurements of objects, the distances or angles between objects, or the X and Y coordinates of a feature. AutoCAD® provides three basic types of dimensioning: linear, radial, and angular. Linear dimensions include aligned, rotated, and ordinate dimensions.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"}]},
{"title":"Parts of a Dimension",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-219c.htm",
"description":"Dimensions are made up of many different objects, such as lines, text, solid fills and blocks. While each dimension type might appear slightly different from one and another, they do have several parts in common.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Dimensioning Concepts","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-21ab.htm"}]},
{"title":"Define the Dimension System Variables",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2193.htm",
"description":"The dimension system variables control the appearance of dimensions. The dimension system variables include DIMAUNIT, DIMUPT, DIMTOFL, DIMFIT, DIMTIH, DIMTOH, DIMJUST, and DIMTAD. You can set these variables by using the SetSystemVariable method which can be accessed from the Application object. For example, the following line of code sets the DIMAUNIT system variable (the units format for angular dimensions) to radians (3):",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Dimensioning Concepts","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-21ab.htm"}]},
{"title":"Set Dimension Text Styles",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2186.htm",
"description":"Dimension text refers to any kind of text associated with dimensions, including measurements, tolerances (both lateral and geometric), prefixes, suffixes, and textual notes in single-line or paragraph form. You can use the default measurement computed by AutoCAD as the text, supply your own text, or suppress the text entirely. You can use dimension text to add information, such as special manufacturing procedures or assembly instructions. Dimension text uses the text style specified by the DIMTXSTY system variable.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Dimensioning Concepts","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-21ab.htm"}]},
{"title":"Understand Leader Lines",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-217c.htm",
"description":"A default leader line is a straight line with an arrowhead that points to a feature in a drawing. Usually, a leader\'s function is to connect annotation with the feature. Annotation in this case means paragraph text, blocks, or feature control frames. Such leader lines are different from the simple leader lines AutoCAD creates automatically for radial, diameter, and linear dimensions whose text does not fit between extension lines.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Dimensioning Concepts","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-21ab.htm"}]},
{"title":"Understand Associative Dimensions",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2173.htm",
"description":"Associative dimensions automatically adjust their locations, orientations, and measurement values when the geometric objects associated with them are modified. The DIMASSOC system variable controls associative dimensioning. Set DIMASSOC to 2 to turn on associative dimensioning.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Dimensioning Concepts","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-21ab.htm"}]},
{"title":"Create Dimensions",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-216b.htm",
"description":"You can create linear, radial, angular, and ordinate dimensions.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"}]},
{"title":"Create Linear Dimensions",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2163.htm",
"description":"Linear dimensions can be aligned or rotated. Aligned dimensions have the dimension line parallel to the line along which the extension line origins lie. Rotated dimensions have the dimension line placed at an angle to the extension line origins.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Create Dimensions","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-216b.htm"}]},
{"title":"Create Radial Dimensions",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2151.htm",
"description":"Radial dimensions measure the radii and diameters of arcs and circles. Radial and diametric dimensions are created by creaing instances of RadialDimension and DiametricDimension objects.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Create Dimensions","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-216b.htm"}]},
{"title":"Create Angular Dimensions",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2130.htm",
"description":"Angular dimensions measure the angle between two lines or three points. For example, you can use them to measure the angle between two radii of a circle. The dimension line forms an arc. Angular dimensioms are created by creating instances of LineAngularDimension2 or Point3AngularDimension objects.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Create Dimensions","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-216b.htm"}]},
{"title":"Create Jogged Radius Dimensions",
"href":"./filesMDG/WS1a9193826455f5ff-e569a012180ce5891-1823.htm",
"description":"Jogged radius dimensions measure the radius of an object and displays the dimension text with a radius symbol in front of it. You might use a jogged dimension over a radial dimension object when:",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Create Dimensions","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-216b.htm"}]},
{"title":"Create Arc Length Dimensions",
"href":"./filesMDG/WS1a9193826455f5ff-e569a012180ce5891-1ee0.htm",
"description":"Arc length dimensions measure the length along an arcand displays the dimension text with an arc symbol that is either above or proceeds it. You might use an arc length dimension when you need to dimension the actual length of an arc instead of just distance between its start and end points.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Create Dimensions","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-216b.htm"}]},
{"title":"Create Ordinate Dimensions",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2121.htm",
"description":"Ordinate, or datum, dimensions measure the perpendicular distance from an origin point, called the datum, to a dimensioned feature, such as a hole in a part. These dimensions prevent escalating errors by maintaining accurate offsets of the features from the datum.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Create Dimensions","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-216b.htm"}]},
{"title":"Edit Dimensions",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-210e.htm",
"description":"As with other graphical objects in AutoCAD, you can edit dimensions using the methods and properties provided for the object.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"}]},
{"title":"Override Dimension Text",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-20cc.htm",
"description":"The dimension value that is displayed can be replaced using the DimensionText property. Using this property you can completely replace the displayed value of the dimension, or you can append text to the value. To represent the measured value in the override dimension text, use the character string “<>” in the text.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Edit Dimensions","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-210e.htm"}]},
{"title":"Work with Dimension Styles",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-20c2.htm",
"description":"A named dimension style is a group of settings that determines the appearance of a dimension. Using named dimension styles, you can establish and enforce drafting standards for the dimensions in a drawing.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"}]},
{"title":"Create, Modify, and Copy Dimension Styles",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-20b1.htm",
"description":"A new dimension style is created by creating an instance of a DimStyleTableRecord object and then adding it to the DimStyleTable with the Add method. Before the dimension style is added to the table, set the name of the new style with the Name property.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Work with Dimension Styles","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-20c2.htm"}]},
{"title":"Override the Dimension Style",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-20a1.htm",
"description":"Each dimension has the capability of overriding the settings assigned to it by a dimension style. The following properties are available for most dimension objects:",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Work with Dimension Styles","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-20c2.htm"}]},
{"title":"Dimension in Model Space and Paper Space",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2003.htm",
"description":"You can draw dimensions in both Model space and Paper space. However, if the geometry you are dimensioning is in Model space, it is best to draw dimensions in Model space because AutoCAD places the definition points in the space where the geometry is drawn.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"}]},
{"title":"Create Leaders and Annotation",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1ff7.htm",
"description":"A leader is a line that connects some annotation to a feature in a drawing. Leaders and their annotation are associative, which means if you modify the annotation, the leader updates accordingly. Do not confuse the Leader object with the leader line AutoCAD automatically generates as part of a dimension line.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"}]},
{"title":"Create Leader Lines",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1fef.htm",
"description":"You can create a leader line from any point or feature in a drawing and control its appearance. Leaders can be straight line segments or smooth spline curves. Leader color is controlled by the current dimension line color. Leader scale is controlled by the overall dimension scale set in the active dimension style. The type and size of the arrowhead, if one is present, is controlled by the arrowhead defined in the active style.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Create Leaders and Annotation","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1ff7.htm"}]},
{"title":"Add the Annotation to a Leader",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1fdb.htm",
"description":"Leader annotation can be a Tolerance, MText, or Block Reference object. You can create a new annotation, or you can append a copy of an existing annotation. Annotation is added to a leader by assigning the object id of the annotation object to the Annotation property.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Create Leaders and Annotation","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1ff7.htm"}]},
{"title":"Leader Associativity",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1fd2.htm",
"description":"Leaders are associated with their annotation so that when the annotation moves, the endpoint of the leader moves with it. As you move text and feature control frame annotation, the final leader line segment alternates between attaching to the left side and to the right side of the annotation according to the relation of the annotation to the penultimate (second to last) point of the leader. If the midpoint of the annotation is to the right of the penultimate leader point, then the leader attaches to the right; otherwise, it attaches to the left.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Create Leaders and Annotation","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1ff7.htm"}]},
{"title":"Edit Leader Associativity",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1fc2.htm",
"description":"Except for the associativity relation between the leader and annotation, the leader and its annotation are entirely separate objects in your drawing. Editing of the leader does not affect the annotation, and editing of the annotation does not affect the leader.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Create Leaders and Annotation","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1ff7.htm"}]},
{"title":"Edit Leaders",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1fb6.htm",
"description":"Any modifications to leader annotation that change its position affect the position of the endpoint of the associated leader. Also, rotating the annotation causes the leader hook line (if any) to rotate.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Create Leaders and Annotation","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1ff7.htm"}]},
{"title":"Use Geometric Tolerances",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1fac.htm",
"description":"Geometric tolerances show deviations of form, profile, orientation, location, and runout of a feature. You add geometric tolerances in feature control frames. These frames contain all the tolerance information for a single dimension.",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"}]},
{"title":"Create Geometric Tolerances",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1fa6.htm",
"description":"You create a geometric tolerance by creating an instance of a FeatureControlFrame object. When you create an instance of a FeatureControlFrame object, its constructor can accept an optional set of parameters. The following parameters can be supplied when you create a new FeatureControlFrame object:",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Use Geometric Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1fac.htm"}]},
{"title":"Edit Geometric Tolerances",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1f9a.htm",
"description":"Geometric tolerances are influenced by several system variables and properties. The following system variables and properties affect the appearance of a geometric tolerance:",
"ancestors":[{"title": "Dimensions and Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2469.htm"},{"title": "Use Geometric Tolerances","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1fac.htm"}]},
{"title":"Work in Three-Dimensional Space",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm",
"description":"Most drawings consist of two-dimensional (2D) views of objects that are three dimensional (3D). Though this method of drafting is widely used in the architectural and engineering communities, it is limited: the drawings are 2D representations of 3D objects and must be visually interpreted. Moreover, because the views are created independently, there are more possibilities for error and ambiguity. As a result, you may want to create true 3D models instead of 2D representations. You can use the AutoCAD drawing tools to create detailed, realistic 3D objects and manipulate them in various ways.",
"ancestors":[]},
{"title":"Specify 3D Coordinates",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-35fe.htm",
"description":"Entering 3D world coordinate system (WCS) coordinates is similar to entering 2D WCS coordinates. In addition to specifying X and Y values, you specify a Z value. 2D coordinates are represented by a Point2d object, while you use a Point3d object to represent 3D coordinates. Most properties and methods in the .NET API utilize 3D coordinates.",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"}]},
{"title":"Define a User Coordinate System",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-35f5.htm",
"description":"You define a user coordinate system ( UCS ) object to change the location of the (0, 0, 0) origin point and the orientation of the XY plane and Z axis. You can locate and orient a UCS anywhere in 3D space, and you can define, save, and recall as many user coordinate systems as you require. Coordinate input and display are relative to the current UCS.",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"}]},
{"title":"Convert Coordinates",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-35da.htm",
"description":"The TransformBy method can translate a point or a displacement from one coordinate system to another. You use the AlignCoordinateSystem method to specify which coordinate system you are translating from and which coordinate system you are going to. The AlignCoordinateSystem method requires the following:",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"}]},
{"title":"Create 3D Objects",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-35ae.htm",
"description":"AutoCAD supports three types of 3D modeling: wireframe, surface, and solid. Each type has its own creation and editing techniques.",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"}]},
{"title":"Create Wireframes",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-35a9.htm",
"description":"With AutoCAD you can create wireframe models by positioning any 2D planar object anywhere in 3D space. You can position 2D objects in 3D space using several methods:",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"},{"title": "Create 3D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-35ae.htm"}]},
{"title":"Create Meshes",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-359a.htm",
"description":"A rectangular mesh (PolygonMesh object) represents the surface of an object using planar facets. The density or number of facets for a mesh is defined in terms of a matrix of M and N vertices, similar to a grid consisting of columns and rows. M and N specify the column and row position, respectively, of any given vertex. You can create meshes in both 2D and 3D, but they are used primarily for 3D.",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"},{"title": "Create 3D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-35ae.htm"}]},
{"title":"Create Polyface Meshes",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3583.htm",
"description":"A polyface mesh represents the surface of an object defined by faces capable of having numerous vertices. Creating a polyface mesh is similar to creating a rectangular mesh. You create a polyface mesh by creating an instance of a PolyFaceMesh object. The constructor of the PolyFaceMesh object does not accept any parameters. To add a vertex to a polyface mesh, you create a PolyFaceMeshVertex and add it to the PolyFaceMesh object using the AppendVertex method.",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"},{"title": "Create 3D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-35ae.htm"}]},
{"title":"Create Solids",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3576.htm",
"description":"A solid object (Solid3d object) represents the entire volume of an object. Solids are the most informationally complete and least ambiguous of the 3D modeling types. Complex solid shapes are also easier to construct and edit than wireframes and meshes.",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"},{"title": "Create 3D Objects","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-35ae.htm"}]},
{"title":"Edit in 3D",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-354c.htm",
"description":"This section describes how to edit 3D objects by, for example, rotating, arraying, and mirroring.",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"}]},
{"title":"Rotate in 3D",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3548.htm",
"description":"With the TransformBy method of an object and the Rotation method of a Matrix, you can rotate objects in 2D about a specified point. The direction of rotation for 2D objects is around the Z axis. For 3D objects, the axis of rotation is not limited to the Z axis. When using the Rotation method instead of using the Z axis for the rotation axis, you specify a specific 3D vector.",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"},{"title": "Edit in 3D","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-354c.htm"}]},
{"title":"Array in 3D",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3537.htm",
"description":"With the TransformBy and Clone methods of an object, you can create a 3D rectangular array. In addition to specifying the number of columns (X direction) and rows (Y direction) like you would for a 2D rectangular array, you also specify the number of levels (Z direction).",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"},{"title": "Edit in 3D","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-354c.htm"}]},
{"title":"Mirror Objects Along a Plane",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-352b.htm",
"description":"With the TransformBy method of an object and the Mirroring method of a Matrix, you can mirror objects along a specified mirroring plane specified by three points.",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"},{"title": "Edit in 3D","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-354c.htm"}]},
{"title":"Edit 3D Solids",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-351b.htm",
"description":"Once you have created a solid, you can create more complex shapes by combining or subtracting solids. You can join solids, subtract solids from each other, or find the common volume (overlapping portion) of solids. Use the BooleanOperation method to perform these combinations. The CheckInterference method allows you to determine if two solids overlap.",
"ancestors":[{"title": "Work in Three-Dimensional Space","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-4865.htm"}]},
{"title":"Define Layouts and Plot",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm",
"description":"After you have created a drawing with AutoCAD, you usually plot or publish it. A plotted drawing can contain a single view of your drawing or a more complex arrangement of views. You create windows called floating viewports in Paper space in which are used to display various views of the drawing. Depending on your needs, you can plot one or more viewports, or set options that determine what is plotted and how the image fits in the final output format.",
"ancestors":[]},
{"title":"Model Space and Paper Space",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34fe.htm",
"description":"Model space is the drawing environment in which you create the geometry for your model. Normally, as you begin to draw in Model space, you designate your drawing limits to determine the extents of the drawing environment, and you draw in real world units.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"}]},
{"title":"Layouts",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34f7.htm",
"description":"All the geometry of your drawing is contained in layouts. Model space geometry is contained on a single layout named Model. You cannot rename the Model space layout, nor can you create another Model space layout as there can be only one per drawing.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"}]},
{"title":"Layouts and Blocks",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34ec.htm",
"description":"The content of any layout is distributed among two different objects: a Layout and BlockTableRecord object. The Layout object contains the plot settings and the visual properties of the layout as it appears in the AutoCAD user interface. The BlockTableRecord object contains the geometry that is displayed on the layout such as annotation, floating viewports, and title blocks. The BlockTableRecord object also includes the Viewport object that controls the display of the drafting aids and layer properties used for the layout.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Layouts","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34f7.htm"}]},
{"title":"Plot Settings",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34e1.htm",
"description":"A PlotSettings object is similar to a Layout object, as both contain identical plot information and this is because the Layout class is derived from the PlotSettings class. The main difference is that a Layout object has an associated BlockTableRecord object containing the geometry to plot. A PlotSettings object is not associated with a particular BlockTableRecord object. It is simply a named collection of plot settings available for use with any geometry. PlotSettings objects are known as page setups in the AutoCAD user interface and are accessed from the Page Setup Manager.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Layouts","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34f7.htm"}]},
{"title":"Layout Settings",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34db.htm",
"description":"Layout settings control the final output of a drawing when plotted or published. These settings affect the paper size, plot scale, plot area, plot origin, and the plot device name. Understanding how to use layout settings ensures that the layout is plotted as expected. Most settings related to outputting a layout are read-only. Changing the plot settings for a layout requires the use of the PlotSettings and PlotSettingsValidator objects.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Layouts","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34f7.htm"}]},
{"title":"Paper Size and Units",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34d5.htm",
"description":"The choice of paper size depends on the plotter or device configured for output. Each plotter or device has a standard list of available output sizes. The output size for a layout is assigned can be quired with the CanonicalMediaName property.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Layouts","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34f7.htm"},{"title": "Layout Settings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34db.htm"}]},
{"title":"Plot Origin",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34cc.htm",
"description":"The plot origin is the lower-left corner of the specified plotted area and can be queried with the PlotOrigin property. Typically, the plot origin is set to (0, 0). However, a plot can be centered on the sheet of paper. The PlotCentered property returns if the plot is currently centered; if TRUE the plot is centered. Centering the plot alters the plot origin.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Layouts","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34f7.htm"},{"title": "Layout Settings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34db.htm"}]},
{"title":"Plot Area",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34c8.htm",
"description":"When a layout is plotted, the area in which is plotted is determined by the PlotType property. The value stored in the PlotType property is one of the values defined by the PlotType enum. The PlotType enum defines the following values:",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Layouts","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34f7.htm"},{"title": "Layout Settings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34db.htm"}]},
{"title":"Plot Scale",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34a8.htm",
"description":"Generally, you draw objects at their actual size. When you plot the drawing, you either specify a precise scale or fit the image to the output size. You specify a scale with either a standard or custom plot scale.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Layouts","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34f7.htm"},{"title": "Layout Settings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34db.htm"}]},
{"title":"Lineweight Scale",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-349d.htm",
"description":"Lineweights can be scaled proportionately in a layout with the plot scale. Typically, lineweights specify the linewidth of plotted objects and are plotted with the linewidth size regardless of the plot scale. Most often, you use the default plot scale of 1:1 when plotting a layout. However, if you want to plot an E-size layout that is scaled to fit on an A-size sheet of paper, for example, you can specify lineweights to be scaled in proportion to the new plot scale.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Layouts","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34f7.htm"},{"title": "Layout Settings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34db.htm"}]},
{"title":"Plot Device",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3496.htm",
"description":"The plot device name is stored in the PlotConfigurationName property. The name should match one of the devices on your system, if not the default device will be used.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Layouts","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34f7.htm"},{"title": "Layout Settings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34db.htm"}]},
{"title":"Query and Set Layout Settings",
"href":"./filesMDG/WS73099cc142f48755-385a98b012180d20f19425f.htm",
"description":"The following example shows how to query and change the device of the current layout.VB.NETImports Autodesk.AutoCAD.RuntimeImports Autodesk.AutoCAD.ApplicationServicesImports Autodesk.AutoCAD.Database",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Layouts","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34f7.htm"},{"title": "Layout Settings","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-34db.htm"}]},
{"title":"Viewports",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3491.htm",
"description":"When working in Model space you draw geometry in tile viewports which are represented by ViewportTableRecord objects. You can display one or several different viewports at a time. If several tiled viewports are displayed, editing in one viewport affects all other viewports. However, you can set the magnification, viewpoint, grid, and snap settings individually for each viewport.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"}]},
{"title":"Floating Viewports",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3482.htm",
"description":"You cannot edit the model from Paper space. To access the model in a Viewport object, toggle from Paper space to Model space using the SwitchToModelSpace and SwitchToPaperSpace member methods of the Editor object. As a result, you can work with the model while keeping the overall layout visible. In Viewport objects, the editing and view-changing capabilities are almost the same as in ViewportTableRecord objects.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Viewports","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3491.htm"}]},
{"title":"Create Paper Space Viewports",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-343a.htm",
"description":"Paper space viewports are created by creating instances of Viewport objects and adding them to the block reference used by a layout other than Model. The constructor for the Viewport object does not accept any parameters to create a new viewport object. Once an instance of a Viewport object iws created, you can define its placement with the CenterPoint, Width and Height properties.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Viewports","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3491.htm"}]},
{"title":"Change Viewport Views and Content",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3416.htm",
"description":"To change the view within a Viewport object, you manipulate the view of a viewport you use its member properties. The following member properties allow you to adjust the display of the view in a viewport:",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Viewports","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3491.htm"}]},
{"title":"Scale Views Relative to Paper Space",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3409.htm",
"description":"Before you plot, you can establish the scale factor for the view in each viewport. Scaling views relative to paper space establishes a consistent scale for each displayed view. For example, the following illustration shows a Paper space view with several viewports—each set to different scales and views.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Viewports","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3491.htm"}]},
{"title":"Scale Pattern Linetypes in Paper Space",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-33f6.htm",
"description":"In Paper space, you can scale any type of linetype in two ways. The scale can be based on the drawing units of the space in which the object was created (Model or Paper). The linetype scale also can be a uniform scale based on Paper space units. You can use the PSLTSCALE system variable to maintain the same linetype scaling for objects displayed at different scales in different viewports. It also affects the line display in 3D views.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Viewports","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3491.htm"}]},
{"title":"Use Shaded Viewports",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-33e9.htm",
"description":"If your drawing contains 3D faces, meshes, extruded objects, surfaces, or solids, you can plot from Paper space using one of the values defined by the ShadePlotStype enum. Shaded and rendered viewports are previewed, plotted, and plotted to file with full shading and rendering.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Viewports","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3491.htm"}]},
{"title":"Plot Your Drawing",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-33d5.htm",
"description":"You can plot your drawing as it is viewed in Model space, or you can plot one of your prepared Paper space layouts. Plotting from Model space is often preferable when you want to view or verify your drawing prior to creating a Paper space layout. Once your model is ready, you can prepare and plot a Paper space layout.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"}]},
{"title":"Plot from Model Space",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-33b0.htm",
"description":"Typically, when you plot a large drawing such as a floorplan, you specify a scale to convert the real drawing units into plotted inches or millimeters. However, when you plot from Model space, the defaults that are used if there are no settings specified include plot to system printer, plot the current display, scaled to fit, 0 rotation, and 0,0 offset.",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Plot Your Drawing","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-33d5.htm"}]},
{"title":"Plot from Paper Space",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-339e.htm",
"description":"You can plot a Paper space layout. Plotting a Paper space layout is the same as plotting the Model layout. Before plotting a Paper space layout, be sure that the layout is initialized and the viewports are defined with the settings and desired views of the model.For information on defining viewports on a Paper space layout, see . To plot a Paper space layout, refer to .",
"ancestors":[{"title": "Define Layouts and Plot","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-245e.htm"},{"title": "Plot Your Drawing","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-33d5.htm"}]},
{"title":"Use Events",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2465.htm",
"description":"Events are notifications, or messages, that are sent out by AutoCAD to inform you about the current state of the session, or alert you that something has happened. For example, when a drawing is saved the BeginSave event is triggered. There are other events triggered when a drawing is closed, a command is started or even when a system variable is changed. Given this information you could write a subroutine, or event handler, that uses these events to track changes to a drawing or the amount of time a user spends working on a particular drawing.",
"ancestors":[]},
{"title":"Understand the Events in AutoCAD",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3779.htm",
"description":"There are mainy different types of events in AutoCAD. The following is some of the common types of events:",
"ancestors":[{"title": "Use Events","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2465.htm"}]},
{"title":"Guidelines for Event Handlers",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-376d.htm",
"description":"It is important to remember that events simply provide information on the state or activities taking place within AutoCAD. Although event handlers can be written to respond to those events, AutoCAD might be in the middle of an operation when the event handler is triggered. Event handlers, therefore, have some restrictions on what they can do if they are to provide safe operations in conjunction with AutoCAD and its database.",
"ancestors":[{"title": "Use Events","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2465.htm"}]},
{"title":"Register and Unregister Events",
"href":"./filesMDG/WS1a9193826455f5ff-e569a0121d1945c08-2d26.htm",
"description":"Before you can respond to an event, the event must be registered with AutoCAD. You register an event by creating a new event handler of the desired type and then assigning it to the object in which you want to register the event with. Once you are done with an event, it is best to unregister the event to minimize conflicts with other reactors as well as reduce the about of memory and CPU usage that AutoCAD requires to maintain your event handler.",
"ancestors":[{"title": "Use Events","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2465.htm"}]},
{"title":"Handle Application Events",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3750.htm",
"description":"Application object events are are used to respond to the application window. Once an Application event is registered, it remains registered until AutoCAD is shutdown or the event is unregistered.",
"ancestors":[{"title": "Use Events","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2465.htm"}]},
{"title":"Handle Document Events",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-36c9.htm",
"description":"Document object events are used to respond to the document window. When a document event is registered, it is only associated with the document object in which it is associated. So if an event needs to be registered with each document, you will want to use the DocumentCreated event of the DocumentCollection object to register events with each new or opened drawing.",
"ancestors":[{"title": "Use Events","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2465.htm"}]},
{"title":"Handle DocumentCollection Events",
"href":"./filesMDG/WS1a9193826455f5ff-e569a0121d1945c08-2024.htm",
"description":"DocumentCollection object events are used to respond to the open documents in the application. DocumentCollection events, unlike Document object events, remain registered until AutoCAD is shutdown or until they are unregistered.",
"ancestors":[{"title": "Use Events","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2465.htm"}]},
{"title":"Handle Object Events",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-3626.htm",
"description":"Object events are used to respond to the opening, adding, modifying, and erasing of objects from a drawing database. There are two types of object related events: object and database level. Object level events are defined to respond to a specific object in a database, whereas Database level events respond to all objects in a database.",
"ancestors":[{"title": "Use Events","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2465.htm"}]},
{"title":"Register COM Based Events with .NET",
"href":"./filesMDG/WS1a9193826455f5ff-e569a0121d1945c08-2cf8.htm",
"description":"The AutoCAD COM Automation library offers some unique events that are not found in the .NET API. Registering events that are in a COM library is different than how you would initialize an event using VB or VBA. You use the VB.NET AddHandler statement or the C# += operator to reigister an event handler with the event. The event handler requires the address of the procedure in which should be called when the event is raised.",
"ancestors":[{"title": "Use Events","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2465.htm"}]},
{"title":"Develop Applications with VB.NET and C#",
"href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-485d.htm",
"description":"Many programming tasks involve more than simply working with the AutoCAD .NET API object model. This chapter provides a brief overview of handling errors and distributing your application to others.",
"ancestors":[]},
{"title":"Handle Errors",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c84.htm",
"description":"Most development environments provide default error handling. For C# and VB.NET, the default reaction to an error is to display an error message and terminate the application. While this behavior is adequate during the development, it is not productive for the user.",
"ancestors":[{"title": "Develop Applications with VB.NET and C#","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-485d.htm"}]},
{"title":"Define Application Error Types",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c7c.htm",
"description":"There are three different types of errors you can encounter in your applications: compile-time errors, runtime errors, and logic errors.",
"ancestors":[{"title": "Develop Applications with VB.NET and C#","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-485d.htm"},{"title": "Handle Errors","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c84.htm"}]},
{"title":"Trap Runtime Errors",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c6f.htm",
"description":"VB.NET and C# support common and language specific ways to handle errors at runtime. The Try statement is available in both C# and VB.NET to trap errors, while the On Error statement is available in VB.NET and Goto is only in C#.",
"ancestors":[{"title": "Develop Applications with VB.NET and C#","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-485d.htm"},{"title": "Handle Errors","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c84.htm"}]},
{"title":"Use Try Statements",
"href":"./filesMDG/WS1a9193826455f5ff3913a1a412260ca5929-7a66.htm",
"description":"In VB.NET and C#, runtime errors can be trapped using a Try statement. This statement literally sets a trap for the system. When an error occurs in a Try statement, the default error handling for the system is bypassed and execution is redirected to its Catch clause.",
"ancestors":[{"title": "Develop Applications with VB.NET and C#","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-485d.htm"},{"title": "Handle Errors","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c84.htm"},{"title": "Trap Runtime Errors","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c6f.htm"}]},
{"title":"Use the Exception Object",
"href":"./filesMDG/WS1a9193826455f5ff3913a1a412260ca5929-7a49.htm",
"description":"The Exception object is used to obtain information about the error trapped with the Catch clause of a Try statement. The Exception object used for the AutoCAD .NET API is based on the Exception object of the Microsoft .NET Framework. To determine the error that is trapped by the Catch clause, you can use the properties of the Exception object. Some of the member properties of the Exception object that you can get information about the error are:",
"ancestors":[{"title": "Develop Applications with VB.NET and C#","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-485d.htm"},{"title": "Handle Errors","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c84.htm"},{"title": "Trap Runtime Errors","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c6f.htm"}]},
{"title":"On Error Statements (VB.NET)",
"href":"./filesMDG/WS1a9193826455f5ff3913a1a412260ca5929-7a45.htm",
"description":"In VB.NET, runtime errors can be trapped with the Try or On Error statement. This statement literally sets a general trap in the application. When an error occurs, this statement automatically detours processing to your specially written error handler. The default error handling for the system is bypassed.",
"ancestors":[{"title": "Develop Applications with VB.NET and C#","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-485d.htm"},{"title": "Handle Errors","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c84.htm"},{"title": "Trap Runtime Errors","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c6f.htm"}]},
{"title":"Compare Error Handlers in VBA or VB to .NET",
"href":"./filesMDG/WS1a9193826455f5ff3913a1a412260ca5929-7a22.htm",
"description":"Error handling in VBA or VB is done using the On Error statements. While the On Error statements can be used with VB.NET without any problems, it is recommended to utilize Try statements instead. Try statements are more flexibility than the On Error Resume Next and On Error GoTo Label statements.",
"ancestors":[{"title": "Develop Applications with VB.NET and C#","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-485d.htm"},{"title": "Handle Errors","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c84.htm"},{"title": "Trap Runtime Errors","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c6f.htm"}]},
{"title":"Respond to User Input Errors",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c4e.htm",
"description":"The user-input methods provide a certain amount of inherent error trapping in that they require the user to enter a certain type of data. If the user tries to enter some other data, AutoCAD rejects the input and re-prompts the user. Using the PromptXXXOption objects with the appropriate GetXXX or SelectXXX methods provide additional control of the user input but can also introduce additional conditions that must be verified before execution continues. For examples of checking the status of input provided by a user, see .",
"ancestors":[{"title": "Develop Applications with VB.NET and C#","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-485d.htm"},{"title": "Handle Errors","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c84.htm"}]},
{"title":"Distribute Your Application",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-1c12.htm",
"description":".NET applications can be distributed in two deployable builds: debug and release.",
"ancestors":[{"title": "Develop Applications with VB.NET and C#","href":"./filesMDG/WS1a9193826455f5ff2566ffd511ff6f8c7ca-485d.htm"}]},
{"title":"VBA/VB to VB.NET and C# Comparison",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2450.htm",
"description":"While most programming languages differ from each other in their syntax and capabilities, there still some fundamental concepts and logic that they share. This appendix serves as a reference to help developers that are familiar with VBA/VB to find the equivalent VB.NET or C# functionality.",
"ancestors":[]},
{"title":"VBA to VB.NET and C# Comparison",
"href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-3c0.htm",
"description":"The following table compares VBA functions with the similar VB.NET and C# functions and operators. The ActiveX library is indicated by “AutoCAD.Application” and the .NET Managed library equivalents are indicated by “Autodesk.AutoCAD” and the VB.NET or C# equivalents are listed as a function or operator.",
"ancestors":[{"title": "VBA/VB to VB.NET and C# Comparison","href":"./filesMDG/WS73099cc142f48755-5c83e7b1120018de8c0-2450.htm"}]},
]);
top.HlpSys.search.data.registerSearchProvider(searchResultProvider);
// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEPpo
// SIG // G+23NhZmqR+Z02bRTf+gggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQkmcv
// SIG // dCh0VnNcPMjBS4YlVDBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGAM8WYSMFBXxvqqFXcQ4zq
// SIG // XNoquogAUvNtKNKmOKIg+8YfhJsJQZ4aO6OSpomBbOc/
// SIG // ww64iFg9EhDKiJJEjSWnfNdvayhThYGXJLVAKEACjRz3
// SIG // ihSowTVJk+AcpsQo6mqU90hlDatq0QPVZczlSf3SyX53
// SIG // wzpsPMCmrB+HMk/N1Eg=
// SIG // End signature block
